/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.featureselection.subset;

import java.util.HashSet;
import java.util.Set;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.featureselection.FeatureSubsetSelection;
import net.sf.javaml.tools.DatasetTools;

public class GreedyBackwardElimination
implements FeatureSubsetSelection {
    private int n;
    private DistanceMeasure dm;
    private Set<Integer> removedAttributes = null;
    private HashSet<Integer> selectedAttributes;

    public GreedyBackwardElimination(int n, DistanceMeasure dm) {
        this.n = n;
        this.dm = dm;
    }

    @Override
    public void build(Dataset data) {
        if (this.n > data.noAttributes()) {
            this.removedAttributes = new HashSet<Integer>();
            return;
        }
        Instance classInstance = DatasetTools.createInstanceFromClass(data);
        this.removedAttributes = new HashSet<Integer>();
        while (this.removedAttributes.size() < data.noAttributes() - this.n) {
            this.removeNext(data, classInstance);
        }
        this.selectedAttributes = new HashSet();
        for (int i = 0; i < data.noAttributes(); ++i) {
            this.selectedAttributes.add(i);
        }
        this.selectedAttributes.removeAll(this.removedAttributes);
    }

    private void removeNext(Dataset data, Instance classInstance) {
        int worstIndex = -1;
        double worstScore = Double.NaN;
        for (int i = 0; i < data.noAttributes(); ++i) {
            if (this.removedAttributes.contains(i)) continue;
            Instance attributeInstance = DatasetTools.createInstanceFromAttribute(data, i);
            double score = this.dm.measure(attributeInstance, classInstance);
            if (Double.isNaN(score)) {
                worstIndex = i;
                break;
            }
            if (worstIndex == -1) {
                worstIndex = i;
                worstScore = score;
                continue;
            }
            if (this.dm.compare(score, worstScore)) continue;
            worstIndex = i;
            worstScore = score;
        }
        this.removedAttributes.add(worstIndex);
    }

    @Override
    public Set<Integer> selectedAttributes() {
        return this.selectedAttributes;
    }

    @Override
    public int noAttributes() {
        return this.selectedAttributes.size();
    }
}

