/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.filter.discretize;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.core.exception.TrainingRequiredException;
import net.sf.javaml.filter.AbstractFilter;
import net.sf.javaml.filter.instance.FloorValueFilter;
import net.sf.javaml.tools.DatasetTools;

public class EqualWidthBinning
extends AbstractFilter {
    private int numBins = 10;
    private Instance range;
    private Instance min;
    private FloorValueFilter rvf = new FloorValueFilter();

    public EqualWidthBinning() {
        this(10);
    }

    public EqualWidthBinning(int numBins) {
        this.numBins = numBins;
    }

    @Override
    public void build(Dataset data) {
        this.min = DatasetTools.minAttributes(data);
        Instance max = DatasetTools.maxAttributes(data);
        this.range = max.minus(this.min);
    }

    @Override
    public void filter(Instance instance) {
        if (this.range == null) {
            throw new TrainingRequiredException();
        }
        Instance tmp = instance.minus(this.min).divide(this.range).multiply(this.numBins - 1);
        instance.clear();
        instance.putAll(tmp);
        this.rvf.filter(instance);
    }

    @Override
    public void filter(Dataset data) {
        if (this.range == null) {
            this.build(data);
        }
        for (Instance i : data) {
            this.filter(i);
        }
    }
}

