/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.filter.missingvalue;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.EuclideanDistance;
import net.sf.javaml.filter.DatasetFilter;
import net.sf.javaml.tools.InstanceTools;
import net.sf.javaml.utils.ArrayUtils;

public class KNearestNeighbors
implements DatasetFilter {
    private int k = 5;

    public void setK(int k) {
        this.k = k;
    }

    @Override
    public void build(Dataset data) {
    }

    @Override
    public void filter(Dataset data) {
        for (Instance i : data) {
            this.removeMissingValues(i, data);
        }
    }

    private void removeMissingValues(Instance inst, Dataset data) {
        if (InstanceTools.hasMissingValues(inst)) {
            double[] sum = new double[inst.noAttributes()];
            double[] count = new double[inst.noAttributes()];
            for (Instance x : data.kNearest(this.k, inst, new EuclideanDistance())) {
                for (int i = 0; i < x.noAttributes(); ++i) {
                    if (Double.isNaN(x.value(i))) continue;
                    int n = i;
                    sum[n] = sum[n] + x.value(i);
                    int n2 = i;
                    count[n2] = count[n2] + 1.0;
                }
            }
            sum = ArrayUtils.divide(sum, count);
            for (int i = 0; i < inst.noAttributes(); ++i) {
                if (!Double.isNaN(inst.value(i)) || count[i] == 0.0) continue;
                inst.put(i, sum[i]);
            }
        }
    }
}

