/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.filter.normalize;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.filter.AbstractFilter;
import net.sf.javaml.tools.DatasetTools;

public class NormalizeMeanIQR135
extends AbstractFilter {
    private Instance mean = null;
    private Instance std = null;

    @Override
    public void build(Dataset data) {
        this.mean = DatasetTools.percentile(data, 50.0);
        DefaultDataset tmp = new DefaultDataset();
        for (Instance i : data) {
            tmp.add(i.minus(this.mean));
        }
        Instance q1 = DatasetTools.percentile(tmp, 25.0);
        Instance q3 = DatasetTools.percentile(tmp, 75.0);
        this.std = q3.minus(q1).divide(1.35);
    }

    @Override
    public void filter(Dataset data) {
        if (data.size() == 0) {
            return;
        }
        if (this.mean == null || this.std == null) {
            this.build(data);
        }
        super.filter(data);
    }

    @Override
    public void filter(Instance instance) {
        if (this.mean == null || this.std == null) {
            throw new RuntimeException("You should first call filterDataset for this filter, some parameters are not yet set.");
        }
        Instance tmp = instance.minus(this.mean).divide(this.std);
        for (int i = 0; i < instance.noAttributes(); ++i) {
            instance.put(i, tmp.value(i));
        }
    }

    public Instance getStd() {
        return this.std;
    }

    public Instance getMean() {
        return this.mean;
    }
}

