/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.matrix;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.sf.javaml.matrix.Matrix;

final class SwapFileMatrix
extends Matrix {
    private RandomAccessFile matrix;
    private int rows;
    private int cols;

    public SwapFileMatrix(int cols, int rows) throws IOException {
        this.cols = cols;
        this.rows = rows;
        File swapFile = File.createTempFile("swap", "matrix");
        swapFile.deleteOnExit();
        this.matrix = new RandomAccessFile(swapFile, "rw");
    }

    @Override
    public int columns() {
        return this.cols;
    }

    @Override
    public double get(int col, int row) {
        try {
            this.matrix.seek((col * row + row) * 8);
            return this.matrix.readDouble();
        }
        catch (IOException e) {
            System.err.println("Something went wrong, but we return 0 anyway.");
            return 0.0;
        }
    }

    @Override
    public void put(int col, int row, double value) {
        try {
            this.matrix.seek((col * row + row) * 8);
            this.matrix.writeDouble(value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int rows() {
        return this.rows;
    }
}

