/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.sampling;

import be.abeel.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.sampling.NormalBootstrapping;
import net.sf.javaml.sampling.SamplingMethod;
import net.sf.javaml.sampling.SubSampling;
import net.sf.javaml.tools.ListTools;

public final class Sampling
extends Enum<Sampling> {
    public static final /* enum */ Sampling SubSampling = new Sampling();
    public static final /* enum */ Sampling NormalBootstrapping = new Sampling();
    public static final /* enum */ Sampling StratifiedSubsampling = new Sampling();
    public static final /* enum */ Sampling StratifiedNormalBootstrapping = new Sampling();
    private static final /* synthetic */ Sampling[] $VALUES;

    public static Sampling[] values() {
        return (Sampling[])$VALUES.clone();
    }

    public static Sampling valueOf(String name) {
        return Enum.valueOf(Sampling.class, name);
    }

    public Pair<Dataset, Dataset> sample(Dataset data, int size, long seed) {
        SamplingMethod s = null;
        switch (this) {
            case NormalBootstrapping: 
            case StratifiedNormalBootstrapping: {
                s = new NormalBootstrapping();
                break;
            }
            case SubSampling: 
            case StratifiedSubsampling: {
                s = new SubSampling();
            }
        }
        assert (s != null);
        List<Integer> sampledIxs = null;
        switch (this) {
            case StratifiedNormalBootstrapping: 
            case StratifiedSubsampling: {
                sampledIxs = this.stratified(s, data, size, seed);
            }
            case NormalBootstrapping: 
            case SubSampling: {
                sampledIxs = this.regular(s, data, size, seed);
            }
        }
        List<Integer> ixs = ListTools.incfill(data.size());
        ixs.removeAll(sampledIxs);
        DefaultDataset in = new DefaultDataset();
        DefaultDataset out = new DefaultDataset();
        for (int i : sampledIxs) {
            in.add(((Instance)data.get(i)).copy());
        }
        for (int i : ixs) {
            out.add(((Instance)data.get(i)).copy());
        }
        return new Pair((Object)in, (Object)out);
    }

    private List<Integer> regular(SamplingMethod s, Dataset data, int size, long seed) {
        List<Integer> ixs = ListTools.incfill(data.size());
        return s.sample(ixs, size, seed);
    }

    private List<Integer> stratified(SamplingMethod s, Dataset data, int size, long seed) {
        ArrayList<Integer> sampled = new ArrayList<Integer>();
        for (Object e : data.classes()) {
            ArrayList<Integer> ixs = new ArrayList<Integer>();
            int index = 0;
            for (Instance i : data) {
                if (i.classValue().equals(e)) {
                    ixs.add(index);
                }
                ++index;
            }
            double fraction = (double)ixs.size() / (double)data.size();
            sampled.addAll(s.sample(ixs, (int)Math.ceil(fraction * (double)size), seed));
        }
        return sampled;
    }

    public Pair<Dataset, Dataset> sample(Dataset inputData) {
        return this.sample(inputData, inputData.size());
    }

    public Pair<Dataset, Dataset> sample(Dataset inputData, int size) {
        return this.sample(inputData, size, System.currentTimeMillis());
    }

    static {
        $VALUES = new Sampling[]{SubSampling, NormalBootstrapping, StratifiedSubsampling, StratifiedNormalBootstrapping};
    }
}

