/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.tools.data;

import be.abeel.io.GZIPPrintWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.core.SparseInstance;
import net.sf.javaml.tools.data.StreamHandler;

public class FileHandler
extends StreamHandler {
    public static Dataset loadDataset(File f, String separator) throws IOException {
        return FileHandler.loadDataset(f, -1, separator);
    }

    public static Dataset loadDataset(File f, int classIndex) throws IOException {
        return FileHandler.loadDataset(f, classIndex, "\t");
    }

    public static Dataset loadDataset(File f) throws IOException {
        return FileHandler.loadDataset(f, -1);
    }

    public static Dataset loadDataset(File f, int classIndex, String separator) throws IOException {
        if (f.getName().endsWith("gz")) {
            return FileHandler.load(new InputStreamReader(new GZIPInputStream(new FileInputStream(f))), classIndex, separator);
        }
        if (f.getName().endsWith("zip")) {
            return FileHandler.load(new InputStreamReader(new ZipInputStream(new FileInputStream(f))), classIndex, separator);
        }
        return FileHandler.load(new InputStreamReader(new FileInputStream(f)), classIndex, separator);
    }

    public static Dataset loadSparseDataset(File f, int classIndex) throws IOException {
        return FileHandler.loadSparseDataset(f, classIndex, "\t", ":");
    }

    public static Dataset loadSparseDataset(File f, int classIndex, String attributeSeparator, String indexSep) throws IOException {
        if (f.getName().endsWith("gz")) {
            return FileHandler.loadSparse(new InputStreamReader(new GZIPInputStream(new FileInputStream(f))), classIndex, attributeSeparator, indexSep);
        }
        if (f.getName().endsWith("zip")) {
            return FileHandler.loadSparse(new InputStreamReader(new ZipInputStream(new FileInputStream(f))), classIndex, attributeSeparator, indexSep);
        }
        return FileHandler.loadSparse(new InputStreamReader(new FileInputStream(f)), classIndex, attributeSeparator, indexSep);
    }

    public static void exportDataset(Dataset data, File outFile, boolean compress, String sep) throws IOException {
        Object out = compress ? new GZIPPrintWriter(outFile) : new PrintWriter(outFile);
        for (Instance inst : data) {
            if (inst.classValue() != null) {
                ((PrintWriter)out).print(inst.classValue() + sep);
            }
            ((PrintWriter)out).println(FileHandler.string(inst, sep));
        }
        ((PrintWriter)out).close();
    }

    private static String string(Instance inst, String sep) {
        StringBuffer out = new StringBuffer();
        if (inst instanceof SparseInstance) {
            for (Integer index : inst.keySet()) {
                if (out.length() != 0) {
                    out.append(sep + index + ":" + inst.value(index));
                    continue;
                }
                out.append(index + ":" + inst.value(index));
            }
        } else {
            out.append(inst.value(0));
            for (int i = 1; i < inst.noAttributes(); ++i) {
                out.append(sep + inst.value(i));
            }
        }
        return out.toString();
    }

    public static void exportDataset(Dataset data, File file) throws IOException {
        FileHandler.exportDataset(data, file, false);
    }

    public static void exportDataset(Dataset data, File file, boolean b) throws IOException {
        FileHandler.exportDataset(data, file, b, "\t");
    }
}

