/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.tools.weka;

import java.util.Vector;
import net.sf.javaml.core.Dataset;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;

public class ToWekaUtils {
    private Instances wData;
    private boolean classSet;
    private Vector<Object> classes = new Vector();

    public ToWekaUtils(Dataset data) {
        this.classes.addAll(data.classes());
        FastVector att = new FastVector();
        for (int i = 0; i < data.noAttributes(); ++i) {
            att.addElement((Object)new Attribute("att" + i));
        }
        this.classSet = data.classes().size() > 0;
        Attribute ca = null;
        if (this.classSet) {
            FastVector fvNominalVal = new FastVector(data.classes().size());
            for (Object e : data.classes()) {
                fvNominalVal.addElement((Object)e.toString());
            }
            ca = new Attribute("classAtt", fvNominalVal);
            att.addElement((Object)ca);
        }
        this.wData = new Instances("generated_from_java-ml_dataset", att, data.size());
        if (this.classSet) {
            assert (ca != null);
            this.wData.setClass(ca);
        }
        for (net.sf.javaml.core.Instance i : data) {
            this.wData.add(this.instanceToWeka(i));
        }
    }

    public Instances getDataset() {
        return this.wData;
    }

    public Instance instanceToWeka(net.sf.javaml.core.Instance inst) {
        double[] values = new double[this.classSet ? inst.noAttributes() + 1 : inst.noAttributes()];
        for (int i = 0; i < (this.classSet ? values.length - 1 : values.length); ++i) {
            values[i] = (Double)inst.get(i);
        }
        Object wI = null;
        wI = inst instanceof net.sf.javaml.core.SparseInstance ? new SparseInstance(1.0, values) : new Instance(1.0, values);
        wI.setDataset(this.wData);
        if (inst.classValue() != null) {
            wI.setClassValue(inst.classValue().toString());
        }
        return wI;
    }

    public Object convertClass(double index) {
        return this.classes.get((int)index);
    }
}

