/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.tools.weka;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.featureselection.FeatureRanking;
import net.sf.javaml.featureselection.FeatureScoring;
import net.sf.javaml.tools.weka.ToWekaUtils;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.supervised.attribute.AttributeSelection;

public class WekaAttributeSelection
implements FeatureScoring,
FeatureRanking {
    private AttributeSelection attrsel;
    private ASEvaluation evaluator;
    private ASSearch Searcher;
    private AttributeEvaluator attreval;
    public int num_attr;
    private Instances newData;
    private double scoring;
    private int ranking;
    private int attr_number;
    public HashMap<Integer, Integer> numbers = new HashMap();

    public WekaAttributeSelection(ASEvaluation evaluator, ASSearch searcher) {
        this.attrsel = new AttributeSelection();
        this.evaluator = evaluator;
        this.Searcher = searcher;
        this.attreval = (AttributeEvaluator)evaluator;
    }

    @Override
    public void build(Dataset data) {
        try {
            Instances inst = new ToWekaUtils(data).getDataset();
            this.attrsel.setEvaluator(this.evaluator);
            this.attrsel.setSearch(this.Searcher);
            this.attrsel.setInputFormat(inst);
            this.newData = Filter.useFilter((Instances)inst, (Filter)this.attrsel);
            this.num_attr = this.newData.numAttributes();
            for (int a = 0; a < this.num_attr - 1; ++a) {
                char ff = this.newData.attribute(a).name().charAt(3);
                this.attr_number = Integer.parseInt(Character.toString(ff));
                this.numbers.put(this.attr_number, new Integer(a));
            }
        }
        catch (Exception ex) {
            Logger.getLogger(WekaAttributeSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public int noAttributes() {
        return this.num_attr;
    }

    @Override
    public double score(int attribute) {
        try {
            this.scoring = this.attreval.evaluateAttribute(attribute);
        }
        catch (Exception ex) {
            Logger.getLogger(WekaAttributeSelection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.scoring;
    }

    @Override
    public int rank(int attIndex) {
        this.ranking = this.numbers.get(attIndex);
        return this.ranking;
    }
}

