/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.utils;

import net.sf.javaml.core.Dataset;
import net.sf.javaml.utils.GammaFunction;

public class LogLikelihoodFunction {
    double alpha0 = 0.1;
    double beta0 = 0.1;
    double lambda0 = 0.1;
    double mu0 = 0.0;
    double count;
    double sum;
    double sum2;

    public double logLikelihoodFunction(double N, double sum, double sum2) {
        double loglikelihood = 0.0;
        double lambda1 = this.lambda0 + N;
        double alpha1 = this.alpha0 + 0.5 * N;
        double beta1 = this.beta0 + 0.5 * (sum2 - Math.pow(sum, 2.0) / N) + this.lambda0 * Math.pow(sum - this.mu0 * N, 2.0) / (2.0 * lambda1 * N);
        loglikelihood = -0.5 * N * Math.log(Math.PI * 2) + 0.5 * Math.log(this.lambda0) + this.alpha0 * Math.log(this.beta0) - GammaFunction.logGamma(this.alpha0) + GammaFunction.logGamma(alpha1) - alpha1 * Math.log(beta1) - 0.5 * Math.log(lambda1);
        return loglikelihood;
    }

    public double logLikelihood(Dataset cluster) {
        double instanceLength = cluster.instance(0).size();
        this.count = instanceLength * (double)cluster.size();
        this.sum = 0.0;
        this.sum2 = 0.0;
        for (int row = 0; row < cluster.size(); ++row) {
            int column = 0;
            while ((double)column < instanceLength) {
                this.sum += cluster.instance(row).value(column);
                this.sum2 += cluster.instance(row).value(column) * cluster.instance(row).value(column);
                ++column;
            }
        }
        double loglikelihood = this.logLikelihoodFunction(this.count, this.sum, this.sum2);
        if (loglikelihood == Double.NEGATIVE_INFINITY || loglikelihood == Double.POSITIVE_INFINITY) {
            loglikelihood = 0.0;
        }
        return loglikelihood;
    }

    public double logLikelihoodC(Dataset cluster) {
        double instanceLength = cluster.instance(0).size();
        double loglikelihood = 0.0;
        double countTotal = 0.0;
        double sumTotal = 0.0;
        double sum2Total = 0.0;
        int column = 0;
        while ((double)column < instanceLength) {
            double loglike = this.logLikelihood(cluster);
            countTotal += this.count;
            sumTotal += this.sum;
            sum2Total += this.sum2;
            loglikelihood += loglike;
            ++column;
        }
        return loglikelihood;
    }

    public double loglikelihoodsum(Dataset[] clusters) {
        double likelihood = 0.0;
        for (int i = 0; i < clusters.length; ++i) {
            likelihood += this.logLikelihoodC(clusters[i]);
        }
        return likelihood;
    }
}

