/*
 * Decompiled with CFR 0.152.
 */
package nz.ac.waikato.cs.weka;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.util.Properties;
import java.util.Random;

public final class Utils {
    public static double log2 = Math.log(2.0);
    public static double SMALL = 1.0E-6;

    public static Properties readProperties(String resourceName) throws Exception {
        Properties defaultProps = new Properties();
        try {
            defaultProps.load(ClassLoader.getSystemResourceAsStream(resourceName));
        }
        catch (Exception ex) {
            System.err.println("Warning, unable to load properties file from system resource (Utils.java)");
        }
        int slInd = resourceName.lastIndexOf(47);
        if (slInd != -1) {
            resourceName = resourceName.substring(slInd + 1);
        }
        Properties userProps = new Properties(defaultProps);
        File propFile = new File(System.getProperties().getProperty("user.home") + File.separatorChar + resourceName);
        if (propFile.exists()) {
            try {
                userProps.load(new FileInputStream(propFile));
            }
            catch (Exception ex) {
                throw new Exception("Problem reading user properties: " + propFile);
            }
        }
        Properties localProps = new Properties(userProps);
        propFile = new File(resourceName);
        if (propFile.exists()) {
            try {
                localProps.load(new FileInputStream(propFile));
            }
            catch (Exception ex) {
                throw new Exception("Problem reading local properties: " + propFile);
            }
        }
        return localProps;
    }

    public static final double correlation(double[] y1, double[] y2, int n) {
        int i;
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        if (n <= 1) {
            return 1.0;
        }
        for (i = 0; i < n; ++i) {
            av1 += y1[i];
            av2 += y2[i];
        }
        av1 /= (double)n;
        av2 /= (double)n;
        for (i = 0; i < n; ++i) {
            y11 += (y1[i] - av1) * (y1[i] - av1);
            y22 += (y2[i] - av2) * (y2[i] - av2);
            y12 += (y1[i] - av1) * (y2[i] - av2);
        }
        double c = y11 * y22 == 0.0 ? 1.0 : y12 / Math.sqrt(Math.abs(y11 * y22));
        return c;
    }

    public static String removeSubstring(String inString, String substring) {
        StringBuffer result = new StringBuffer();
        int oldLoc = 0;
        int loc = 0;
        while ((loc = inString.indexOf(substring, oldLoc)) != -1) {
            result.append(inString.substring(oldLoc, loc));
            oldLoc = loc + substring.length();
        }
        result.append(inString.substring(oldLoc));
        return result.toString();
    }

    public static String replaceSubstring(String inString, String subString, String replaceString) {
        StringBuffer result = new StringBuffer();
        int oldLoc = 0;
        int loc = 0;
        while ((loc = inString.indexOf(subString, oldLoc)) != -1) {
            result.append(inString.substring(oldLoc, loc));
            result.append(replaceString);
            oldLoc = loc + subString.length();
        }
        result.append(inString.substring(oldLoc));
        return result.toString();
    }

    public static String padLeft(String inString, int length) {
        return Utils.fixStringLength(inString, length, false);
    }

    public static String padRight(String inString, int length) {
        return Utils.fixStringLength(inString, length, true);
    }

    private static String fixStringLength(String inString, int length, boolean right) {
        if (inString.length() < length) {
            while (inString.length() < length) {
                inString = right ? inString.concat(" ") : " ".concat(inString);
            }
        } else if (inString.length() > length) {
            inString = inString.substring(0, length);
        }
        return inString;
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            int dotPosition;
            long precisionValue = temp > 0.0 ? (long)(temp + 0.5) : -((long)(Math.abs(temp) + 0.5));
            StringBuffer stringBuffer = precisionValue == 0L ? new StringBuffer(String.valueOf(0)) : new StringBuffer(String.valueOf(precisionValue));
            if (afterDecimalPoint == 0) {
                return stringBuffer.toString();
            }
            for (dotPosition = stringBuffer.length() - afterDecimalPoint; precisionValue < 0L && dotPosition < 1 || dotPosition < 0; ++dotPosition) {
                if (precisionValue < 0L) {
                    stringBuffer.insert(1, '0');
                    continue;
                }
                stringBuffer.insert(0, '0');
            }
            stringBuffer.insert(dotPosition, '.');
            if (precisionValue < 0L && stringBuffer.charAt(1) == '.') {
                stringBuffer.insert(1, '0');
            } else if (stringBuffer.charAt(0) == '.') {
                stringBuffer.insert(0, '0');
            }
            int currentPos = stringBuffer.length() - 1;
            while (currentPos > dotPosition && stringBuffer.charAt(currentPos) == '0') {
                stringBuffer.setCharAt(currentPos--, ' ');
            }
            if (stringBuffer.charAt(currentPos) == '.') {
                stringBuffer.setCharAt(currentPos, ' ');
            }
            return stringBuffer.toString().trim();
        }
        return new String("" + value);
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint) {
        int i;
        int dotPosition;
        String tempString = Utils.doubleToString(value, afterDecimalPoint);
        if (afterDecimalPoint >= width || tempString.indexOf(69) != -1) {
            return tempString;
        }
        char[] result = new char[width];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = 32;
        }
        if (afterDecimalPoint > 0) {
            dotPosition = tempString.indexOf(46);
            if (dotPosition == -1) {
                dotPosition = tempString.length();
            } else {
                result[width - afterDecimalPoint - 1] = 46;
            }
        } else {
            dotPosition = tempString.length();
        }
        int offset = width - afterDecimalPoint - dotPosition;
        if (afterDecimalPoint > 0) {
            --offset;
        }
        if (offset < 0) {
            return tempString;
        }
        for (i = 0; i < dotPosition; ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        for (i = dotPosition + 1; i < tempString.length(); ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        return new String(result);
    }

    public static Class getArrayClass(Class c) {
        if (c.getComponentType().isArray()) {
            return Utils.getArrayClass(c.getComponentType());
        }
        return c.getComponentType();
    }

    public static int getArrayDimensions(Class array) {
        if (array.getComponentType().isArray()) {
            return 1 + Utils.getArrayDimensions(array.getComponentType());
        }
        return 1;
    }

    public static int getArrayDimensions(Object array) {
        return Utils.getArrayDimensions(array.getClass());
    }

    public static String arrayToString(Object array) {
        String result = "";
        int dimensions = Utils.getArrayDimensions(array);
        if (dimensions == 0) {
            result = "null";
        } else if (dimensions == 1) {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = Array.get(array, i) == null ? result + "null" : result + Array.get(array, i).toString();
            }
        } else {
            for (int i = 0; i < Array.getLength(array); ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + "[" + Utils.arrayToString(Array.get(array, i)) + "]";
            }
        }
        return result;
    }

    public static boolean eq(double a, double b) {
        return a - b < SMALL && b - a < SMALL;
    }

    public static void checkForRemainingOptions(String[] options) throws Exception {
        int illegalOptionsFound = 0;
        StringBuffer text = new StringBuffer();
        if (options == null) {
            return;
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() <= 0) continue;
            ++illegalOptionsFound;
            text.append(options[i] + ' ');
        }
        if (illegalOptionsFound > 0) {
            throw new Exception("Illegal options: " + text);
        }
    }

    public static boolean getFlag(char flag, String[] options) throws Exception {
        return Utils.getFlag("" + flag, options);
    }

    public static boolean getFlag(String flag, String[] options) throws Exception {
        int pos = Utils.getOptionPos(flag, options);
        if (pos > -1) {
            options[pos] = "";
        }
        return pos > -1;
    }

    public static String getOption(char flag, String[] options) throws Exception {
        return Utils.getOption("" + flag, options);
    }

    public static String getOption(String flag, String[] options) throws Exception {
        int i = Utils.getOptionPos(flag, options);
        if (i > -1) {
            if (options[i].equals("-" + flag)) {
                if (i + 1 == options.length) {
                    throw new Exception("No value given for -" + flag + " option.");
                }
                options[i] = "";
                String newString = new String(options[i + 1]);
                options[i + 1] = "";
                return newString;
            }
            if (options[i].charAt(1) == '-') {
                return "";
            }
        }
        return "";
    }

    public static int getOptionPos(char flag, String[] options) {
        return Utils.getOptionPos("" + flag, options);
    }

    public static int getOptionPos(String flag, String[] options) {
        if (options == null) {
            return -1;
        }
        for (int i = 0; i < options.length; ++i) {
            if (options[i].length() <= 0 || options[i].charAt(0) != '-') continue;
            try {
                Double.valueOf(options[i]);
                continue;
            }
            catch (NumberFormatException e) {
                if (options[i].equals("-" + flag)) {
                    return i;
                }
                if (options[i].charAt(1) != '-') continue;
                return -1;
            }
        }
        return -1;
    }

    public static String quote(String string) {
        boolean quote = false;
        if (string.indexOf(10) != -1 || string.indexOf(13) != -1 || string.indexOf(39) != -1 || string.indexOf(34) != -1 || string.indexOf(92) != -1 || string.indexOf(9) != -1 || string.indexOf(37) != -1) {
            string = Utils.backQuoteChars(string);
            quote = true;
        }
        if (quote || string.indexOf(123) != -1 || string.indexOf(125) != -1 || string.indexOf(44) != -1 || string.equals("?") || string.indexOf(32) != -1 || string.equals("")) {
            string = "'".concat(string).concat("'");
        }
        return string;
    }

    public static String backQuoteChars(String string) {
        char[] charsFind = new char[]{'\\', '\'', '\t', '\"', '%'};
        String[] charsReplace = new String[]{"\\\\", "\\'", "\\t", "\\\"", "\\%"};
        for (int i = 0; i < charsFind.length; ++i) {
            int index;
            if (string.indexOf(charsFind[i]) == -1) continue;
            StringBuffer newStringBuffer = new StringBuffer();
            while ((index = string.indexOf(charsFind[i])) != -1) {
                if (index > 0) {
                    newStringBuffer.append(string.substring(0, index));
                }
                newStringBuffer.append(charsReplace[i]);
                if (index + 1 < string.length()) {
                    string = string.substring(index + 1);
                    continue;
                }
                string = "";
            }
            newStringBuffer.append(string);
            string = newStringBuffer.toString();
        }
        return Utils.convertNewLines(string);
    }

    public static String convertNewLines(String string) {
        int index;
        StringBuffer newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(10)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('n');
            if (index + 1 < string.length()) {
                string = string.substring(index + 1);
                continue;
            }
            string = "";
        }
        newStringBuffer.append(string);
        string = newStringBuffer.toString();
        newStringBuffer = new StringBuffer();
        while ((index = string.indexOf(13)) != -1) {
            if (index > 0) {
                newStringBuffer.append(string.substring(0, index));
            }
            newStringBuffer.append('\\');
            newStringBuffer.append('r');
            if (index + 1 < string.length()) {
                string = string.substring(index + 1);
                continue;
            }
            string = "";
        }
        newStringBuffer.append(string);
        return newStringBuffer.toString();
    }

    public static String[] partitionOptions(String[] options) {
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("--")) continue;
            options[i++] = "";
            String[] result = new String[options.length - i];
            for (int j = i; j < options.length; ++j) {
                result[j - i] = options[j];
                options[j] = "";
            }
            return result;
        }
        return new String[0];
    }

    public static String unbackQuoteChars(String string) {
        String[] charsFind = new String[]{"\\\\", "\\'", "\\t", "\\\"", "\\%"};
        char[] charsReplace = new char[]{'\\', '\'', '\t', '\"', '%'};
        for (int i = 0; i < charsFind.length; ++i) {
            int index;
            if (string.indexOf(charsFind[i]) == -1) continue;
            StringBuffer newStringBuffer = new StringBuffer();
            while ((index = string.indexOf(charsFind[i])) != -1) {
                if (index > 0) {
                    newStringBuffer.append(string.substring(0, index));
                }
                newStringBuffer.append(charsReplace[i]);
                if (index + charsFind[i].length() < string.length()) {
                    string = string.substring(index + charsFind[i].length());
                    continue;
                }
                string = "";
            }
            newStringBuffer.append(string);
            string = newStringBuffer.toString();
        }
        return Utils.convertNewLines(string);
    }

    public static double info(int[] counts) {
        int total = 0;
        double x = 0.0;
        for (int j = 0; j < counts.length; ++j) {
            x -= Utils.xlogx(counts[j]);
            total += counts[j];
        }
        return x + Utils.xlogx(total);
    }

    public static boolean smOrEq(double a, double b) {
        return a - b < SMALL;
    }

    public static boolean grOrEq(double a, double b) {
        return b - a < SMALL;
    }

    public static boolean sm(double a, double b) {
        return b - a > SMALL;
    }

    public static boolean gr(double a, double b) {
        return a - b > SMALL;
    }

    public static double kthSmallestValue(int[] array, int k) {
        int[] index = new int[array.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        return array[index[Utils.select(array, index, 0, array.length - 1, k)]];
    }

    public static double kthSmallestValue(double[] array, int k) {
        int[] index = new int[array.length];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        return array[index[Utils.select(array, index, 0, array.length - 1, k)]];
    }

    public static double log2(double a) {
        return Math.log(a) / log2;
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] > maximum)) continue;
            maxIndex = i;
            maximum = doubles[i];
        }
        return maxIndex;
    }

    public static int maxIndex(int[] ints) {
        int maximum = 0;
        int maxIndex = 0;
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0 && ints[i] <= maximum) continue;
            maxIndex = i;
            maximum = ints[i];
        }
        return maxIndex;
    }

    public static double mean(double[] vector) {
        double sum = 0.0;
        if (vector.length == 0) {
            return 0.0;
        }
        for (int i = 0; i < vector.length; ++i) {
            sum += vector[i];
        }
        return sum / (double)vector.length;
    }

    public static int minIndex(int[] ints) {
        int minimum = 0;
        int minIndex = 0;
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0 && ints[i] >= minimum) continue;
            minIndex = i;
            minimum = ints[i];
        }
        return minIndex;
    }

    public static int minIndex(double[] doubles) {
        double minimum = 0.0;
        int minIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] < minimum)) continue;
            minIndex = i;
            minimum = doubles[i];
        }
        return minIndex;
    }

    public static void normalize(double[] doubles) {
        double sum = 0.0;
        for (int i = 0; i < doubles.length; ++i) {
            sum += doubles[i];
        }
        Utils.normalize(doubles, sum);
    }

    public static void normalize(double[] doubles, double sum) {
        if (Double.isNaN(sum)) {
            throw new IllegalArgumentException("Can't normalize array. Sum is NaN.");
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Can't normalize array. Sum is zero.");
        }
        int i = 0;
        while (i < doubles.length) {
            int n = i++;
            doubles[n] = doubles[n] / sum;
        }
    }

    public static double[] logs2probs(double[] a) {
        double max = a[Utils.maxIndex(a)];
        double sum = 0.0;
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.exp(a[i] - max);
            sum += result[i];
        }
        Utils.normalize(result, sum);
        return result;
    }

    public static double probToLogOdds(double prob) {
        if (Utils.gr(prob, 1.0) || Utils.sm(prob, 0.0)) {
            throw new IllegalArgumentException("probToLogOdds: probability must be in [0,1] " + prob);
        }
        double p = SMALL + (1.0 - 2.0 * SMALL) * prob;
        return Math.log(p / (1.0 - p));
    }

    public static int round(double value) {
        int roundedValue = value > 0.0 ? (int)(value + 0.5) : -((int)(Math.abs(value) + 0.5));
        return roundedValue;
    }

    public static int probRound(double value, Random rand) {
        if (value >= 0.0) {
            double lower = Math.floor(value);
            double prob = value - lower;
            if (rand.nextDouble() < prob) {
                return (int)lower + 1;
            }
            return (int)lower;
        }
        double lower = Math.floor(Math.abs(value));
        double prob = Math.abs(value) - lower;
        if (rand.nextDouble() < prob) {
            return -((int)lower + 1);
        }
        return -((int)lower);
    }

    public static double roundDouble(double value, int afterDecimalPoint) {
        double mask = Math.pow(10.0, afterDecimalPoint);
        return (double)Math.round(value * mask) / mask;
    }

    public static int[] sort(int[] array) {
        int i;
        int[] index = new int[array.length];
        int[] newIndex = new int[array.length];
        for (i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        Utils.quickSort(array, index, 0, array.length - 1);
        i = 0;
        while (i < index.length) {
            int j;
            int numEqual = 1;
            for (j = i + 1; j < index.length && array[index[i]] == array[index[j]]; ++j) {
                ++numEqual;
            }
            if (numEqual > 1) {
                int[] helpIndex = new int[numEqual];
                for (j = 0; j < numEqual; ++j) {
                    helpIndex[j] = i + j;
                }
                Utils.quickSort(index, helpIndex, 0, numEqual - 1);
                for (j = 0; j < numEqual; ++j) {
                    newIndex[i + j] = index[helpIndex[j]];
                }
                i += numEqual;
                continue;
            }
            newIndex[i] = index[i];
            ++i;
        }
        return newIndex;
    }

    public static int[] sort(double[] array) {
        int[] index = new int[array.length];
        array = (double[])array.clone();
        for (int i = 0; i < index.length; ++i) {
            index[i] = i;
            if (!Double.isNaN(array[i])) continue;
            array[i] = Double.MAX_VALUE;
        }
        Utils.quickSort(array, index, 0, array.length - 1);
        return index;
    }

    public static int[] stableSort(double[] array) {
        int i;
        int[] index = new int[array.length];
        int[] newIndex = new int[array.length];
        array = (double[])array.clone();
        for (i = 0; i < index.length; ++i) {
            index[i] = i;
            if (!Double.isNaN(array[i])) continue;
            array[i] = Double.MAX_VALUE;
        }
        Utils.quickSort(array, index, 0, array.length - 1);
        i = 0;
        while (i < index.length) {
            int j;
            int numEqual = 1;
            for (j = i + 1; j < index.length && Utils.eq(array[index[i]], array[index[j]]); ++j) {
                ++numEqual;
            }
            if (numEqual > 1) {
                int[] helpIndex = new int[numEqual];
                for (j = 0; j < numEqual; ++j) {
                    helpIndex[j] = i + j;
                }
                Utils.quickSort(index, helpIndex, 0, numEqual - 1);
                for (j = 0; j < numEqual; ++j) {
                    newIndex[i + j] = index[helpIndex[j]];
                }
                i += numEqual;
                continue;
            }
            newIndex[i] = index[i];
            ++i;
        }
        return newIndex;
    }

    public static double variance(double[] vector) {
        double sum = 0.0;
        double sumSquared = 0.0;
        if (vector.length <= 1) {
            return 0.0;
        }
        for (int i = 0; i < vector.length; ++i) {
            sum += vector[i];
            sumSquared += vector[i] * vector[i];
        }
        double result = (sumSquared - sum * sum / (double)vector.length) / (double)(vector.length - 1);
        if (result < 0.0) {
            return 0.0;
        }
        return result;
    }

    public static double sum(double[] doubles) {
        double sum = 0.0;
        for (int i = 0; i < doubles.length; ++i) {
            sum += doubles[i];
        }
        return sum;
    }

    public static int sum(int[] ints) {
        int sum = 0;
        for (int i = 0; i < ints.length; ++i) {
            sum += ints[i];
        }
        return sum;
    }

    public static double xlogx(int c) {
        if (c == 0) {
            return 0.0;
        }
        return (double)c * Utils.log2(c);
    }

    private static int partition(double[] array, int[] index, int l, int r) {
        double pivot = array[index[(l + r) / 2]];
        while (l < r) {
            while (array[index[l]] < pivot && l < r) {
                ++l;
            }
            while (array[index[r]] > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && array[index[r]] > pivot) {
            --r;
        }
        return r;
    }

    private static int partition(int[] array, int[] index, int l, int r) {
        double pivot = array[index[(l + r) / 2]];
        while (l < r) {
            while ((double)array[index[l]] < pivot && l < r) {
                ++l;
            }
            while ((double)array[index[r]] > pivot && l < r) {
                --r;
            }
            if (l >= r) continue;
            int help = index[l];
            index[l] = index[r];
            index[r] = help;
            ++l;
            --r;
        }
        if (l == r && (double)array[index[r]] > pivot) {
            --r;
        }
        return r;
    }

    private static void quickSort(double[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = Utils.partition(array, index, left, right);
            Utils.quickSort(array, index, left, middle);
            Utils.quickSort(array, index, middle + 1, right);
        }
    }

    private static void quickSort(int[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = Utils.partition(array, index, left, right);
            Utils.quickSort(array, index, left, middle);
            Utils.quickSort(array, index, middle + 1, right);
        }
    }

    private static int select(double[] array, int[] index, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = Utils.partition(array, index, left, right);
        if (middle - left + 1 >= k) {
            return Utils.select(array, index, left, middle, k);
        }
        return Utils.select(array, index, middle + 1, right, k - (middle - left + 1));
    }

    private static int select(int[] array, int[] index, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int middle = Utils.partition(array, index, left, right);
        if (middle - left + 1 >= k) {
            return Utils.select(array, index, left, middle, k);
        }
        return Utils.select(array, index, middle + 1, right, k - (middle - left + 1));
    }
}

