/*
 * Decompiled with CFR 0.152.
 */
package simpletree.basics.color;

import simpletree.basics.color.BlueToCyanScale;
import simpletree.basics.color.BlueToYellowScale;
import simpletree.basics.color.CategoryScale;
import simpletree.basics.color.ColorScale;
import simpletree.basics.color.DynamicScale;
import simpletree.basics.color.GrayScale;
import simpletree.basics.color.GreenToWhiteScale;
import simpletree.basics.color.HeatedObjectScale;
import simpletree.basics.color.LinearGrayScale;
import simpletree.basics.color.LocsScale;
import simpletree.basics.color.PseudoRainbowScale;
import simpletree.basics.color.RainbowScale;

public class ColorScaleFactory {
    public static ColorScale getInstance(ColorScaleType type) {
        if (type == ColorScaleType.HEATED_OBJECTS) {
            return new HeatedObjectScale();
        }
        if (type == ColorScaleType.GRAY_SCALE) {
            return new GrayScale();
        }
        if (type == ColorScaleType.LINEAR_GRAY_SCALE) {
            return new LinearGrayScale();
        }
        if (type == ColorScaleType.LOCS_SCALE) {
            return new LocsScale();
        }
        if (type == ColorScaleType.RAINBOW_SCALE) {
            return new RainbowScale();
        }
        if (type == ColorScaleType.PSEUDO_RAINBOW_SCALE) {
            return new PseudoRainbowScale();
        }
        if (type == ColorScaleType.CATEGORY_SCALE) {
            return new CategoryScale();
        }
        if (type == ColorScaleType.BLUE_TO_YELLOW_SCALE) {
            return new BlueToYellowScale();
        }
        if (type == ColorScaleType.BLUE_TO_CYAN) {
            return new BlueToCyanScale();
        }
        if (type == ColorScaleType.GREEN_TO_WHITE_SCALE) {
            return new GreenToWhiteScale();
        }
        if (type == ColorScaleType.DYNAMIC_SCALE) {
            return new DynamicScale();
        }
        return null;
    }

    public static enum ColorScaleType {
        HEATED_OBJECTS("Heated objects scale"),
        GRAY_SCALE("Gray scale"),
        LINEAR_GRAY_SCALE("Linear gray scale"),
        LOCS_SCALE("Linear Optminal Color Scale (LOCS)"),
        RAINBOW_SCALE("Rainbow scale"),
        PSEUDO_RAINBOW_SCALE("Pseudo-rainbow scale"),
        DYNAMIC_SCALE("Dynamic scale"),
        CATEGORY_SCALE("Category scale"),
        BLUE_TO_YELLOW_SCALE("Blue to yellow scale"),
        BLUE_TO_CYAN("Blue to cyan scale"),
        GREEN_TO_WHITE_SCALE("Green to white scale");

        private final String name;

        private ColorScaleType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

