/*
 * Decompiled with CFR 0.152.
 */
package simpletree.coordination;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import simpletree.coordination.IdentityCoordinator;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.view.SimpleTreeFrame;
import simpletree.view.SimpleTreeReportView;

public class SimpleTreeClassMatchCoordination
extends IdentityCoordinator {
    ArrayList<SimpleTreeFrame> frames = new ArrayList();

    public void match() {
        Scalar scalar = new Scalar("ClassMatch");
        scalar.store(0.0f);
        scalar.store(2.0f);
        TreeMap<Float, HashMap<Float, Integer>> confuseData0 = new TreeMap<Float, HashMap<Float, Integer>>();
        TreeMap<Float, HashMap<Float, Integer>> confuseData1 = new TreeMap<Float, HashMap<Float, Integer>>();
        int numMatching0 = 0;
        int numMatching1 = 0;
        int numNonMatching0 = 0;
        int numNonMatching1 = 0;
        int numNonCorresponding0 = 0;
        int numNonCorresponding1 = 0;
        if (this.models.size() == 2) {
            SimpleTreeInstance pi1;
            int i;
            SimpleTreeModel model0 = (SimpleTreeModel)this.models.get(0);
            SimpleTreeModel model1 = (SimpleTreeModel)this.models.get(1);
            if (model0.getScalarByName("ClassMatch") == null) {
                model0.addScalar(scalar);
            }
            if (model1.getScalarByName("ClassMatch") == null) {
                model1.addScalar(scalar);
            }
            for (i = 0; i < model0.getValidInstances().size(); ++i) {
                pi1 = (SimpleTreeInstance)model0.getValidInstances().get(i);
                pi1.setScalarValue(scalar, 0.0f);
            }
            for (i = 0; i < model1.getValidInstances().size(); ++i) {
                pi1 = (SimpleTreeInstance)model1.getValidInstances().get(i);
                pi1.setScalarValue(scalar, 0.0f);
            }
            Scalar cdata1 = model0.getScalarByName("cdata");
            Scalar cdata2 = model1.getScalarByName("cdata");
            if (cdata1 == null || cdata2 == null) {
                return;
            }
            for (i = 0; i < model0.getValidInstances().size(); ++i) {
                int qt;
                SimpleTreeInstance pi2;
                pi1 = (SimpleTreeInstance)model0.getValidInstances().get(i);
                if (!pi1.isValid() || (pi2 = model1.getInstanceById(pi1.getId())) == null) continue;
                if (pi1.getScalarValue(cdata1) == pi2.getScalarValue(cdata2)) {
                    pi1.setScalarValue(scalar, 1.0f);
                    pi2.setScalarValue(scalar, 1.0f);
                    ++numMatching0;
                    ++numMatching1;
                } else {
                    pi1.setScalarValue(scalar, 2.0f);
                    pi2.setScalarValue(scalar, 2.0f);
                    ++numNonMatching0;
                    ++numNonMatching1;
                }
                if (!confuseData0.containsKey(Float.valueOf(pi1.getScalarValue(cdata1)))) {
                    confuseData0.put(Float.valueOf(pi1.getScalarValue(cdata1)), new HashMap());
                }
                if (!confuseData0.get(Float.valueOf(pi1.getScalarValue(cdata1))).containsKey(Float.valueOf(pi2.getScalarValue(cdata2)))) {
                    confuseData0.get(Float.valueOf(pi1.getScalarValue(cdata1))).put(Float.valueOf(pi2.getScalarValue(cdata2)), 1);
                } else {
                    qt = confuseData0.get(Float.valueOf(pi1.getScalarValue(cdata1))).get(Float.valueOf(pi2.getScalarValue(cdata2)));
                    confuseData0.get(Float.valueOf(pi1.getScalarValue(cdata1))).put(Float.valueOf(pi2.getScalarValue(cdata2)), qt + 1);
                }
                if (!confuseData1.containsKey(Float.valueOf(pi2.getScalarValue(cdata2)))) {
                    confuseData1.put(Float.valueOf(pi2.getScalarValue(cdata2)), new HashMap());
                }
                if (!confuseData1.get(Float.valueOf(pi2.getScalarValue(cdata2))).containsKey(Float.valueOf(pi1.getScalarValue(cdata1)))) {
                    confuseData1.get(Float.valueOf(pi2.getScalarValue(cdata2))).put(Float.valueOf(pi1.getScalarValue(cdata1)), 1);
                    continue;
                }
                qt = confuseData1.get(Float.valueOf(pi2.getScalarValue(cdata2))).get(Float.valueOf(pi1.getScalarValue(cdata1)));
                confuseData1.get(Float.valueOf(pi2.getScalarValue(cdata2))).put(Float.valueOf(pi1.getScalarValue(cdata1)), qt + 1);
            }
            numNonCorresponding0 = model0.getValidInstances().size() - numMatching0 - numNonMatching0;
            this.updateFrame(this.frames.get(0), scalar, numMatching0, numNonMatching0, numNonCorresponding0, confuseData0);
            numNonCorresponding1 = model1.getValidInstances().size() - numMatching1 - numNonMatching1;
            this.updateFrame(this.frames.get(1), scalar, numMatching1, numNonMatching1, numNonCorresponding1, confuseData1);
        }
    }

    public synchronized void addFrame(SimpleTreeFrame frame) {
        if (frame == null) {
            throw new NullPointerException();
        }
        if (!this.frames.contains(frame)) {
            this.frames.add(frame);
        }
    }

    private void updateFrame(SimpleTreeFrame frame, Scalar classMatch, int numMatching, int numNonMatching, int numNonCorresponding, TreeMap<Float, HashMap<Float, Integer>> confuseData) {
        frame.updateScalars(classMatch);
        ((SimpleTreeReportView)frame.getReportPanel()).setClassMatchingPanel(classMatch.getName(), numMatching + numNonMatching + numNonCorresponding, numMatching, numNonMatching, numNonCorresponding, confuseData);
        ((SimpleTreeReportView)frame.getReportPanel()).setColorTable(((SimpleTreeModel)frame.getModel()).getColorTable());
        ((SimpleTreeModel)frame.getModel()).notifyObservers();
    }
}

