/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import simpletree.datamining.clustering.Clustering;
import simpletree.datamining.neighbors.KNN;
import simpletree.datamining.neighbors.Pair;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;

public class Jdbscan2D
extends Clustering {
    private int nrNeighbors = 4;
    private float eps = 0.0f;

    public Jdbscan2D() {
        super(0);
    }

    public Jdbscan2D(float eps) {
        super(0);
        this.eps = eps;
    }

    public Jdbscan2D(float eps, int n) {
        super(0);
        this.eps = eps;
        this.nrNeighbors = n;
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(AbstractDissimilarity diss, AbstractMatrix matrix) throws IOException {
        if (diss instanceof Euclidean) {
            DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
            return this.execute(dmat);
        }
        throw new IOException("The dissimilarity should be Euclidean!");
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        if (this.eps == 0.0f) {
            this.eps = this.calculateEps(dmat);
        }
        ArrayList<Point> points_aux = new ArrayList<Point>();
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            points_aux.add(new Point(i));
        }
        this.dbscan(dmat, points_aux, this.eps, 7);
        this.nrclusters = 0;
        for (Point p : points_aux) {
            if (p.clusterId <= this.nrclusters) continue;
            this.nrclusters = p.clusterId;
        }
        ArrayList<ArrayList<Integer>> clusters = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < this.nrclusters + 1; ++i) {
            clusters.add(new ArrayList());
        }
        for (Point p : points_aux) {
            if (p.clusterId <= -1) continue;
            clusters.get(p.clusterId).add(p.id);
        }
        return clusters;
    }

    private float calculateEps(DistanceMatrix dmat) throws IOException {
        float[] max_ray = new float[dmat.getElementCount()];
        KNN knn = new KNN(this.nrNeighbors);
        Pair[][] neighbors = knn.execute(dmat);
        for (int p = 0; p < neighbors.length; ++p) {
            float max_dist = Float.MIN_VALUE;
            for (int n = 0; n < neighbors[p].length; ++n) {
                if (!(neighbors[p][n].value > max_dist)) continue;
                max_dist = neighbors[p][n].value;
            }
            max_ray[p] = max_dist;
        }
        Arrays.sort(max_ray);
        return max_ray[(int)((float)dmat.getElementCount() * 0.85f)];
    }

    private void dbscan(DistanceMatrix dmat, ArrayList<Point> points, float eps, int minPts) {
        int clusterId = this.nextId(-1);
        for (int i = 0; i < points.size(); ++i) {
            Point p = points.get(i);
            if (p.clusterId != -2 || !this.expandCluster(dmat, points, p, clusterId, eps, minPts)) continue;
            clusterId = this.nextId(clusterId);
        }
    }

    private boolean expandCluster(DistanceMatrix dmat, ArrayList<Point> points, Point p, int clusterId, float eps, int minPts) {
        ArrayList<Point> seeds = this.regionQuery(dmat, points, p, eps);
        if (seeds.size() < minPts) {
            this.changeClusterId(p, -1);
            return false;
        }
        this.changeClusterIds(seeds, clusterId);
        seeds.remove(p);
        while (seeds.size() > 0) {
            Point currentP = seeds.get(0);
            ArrayList<Point> result = this.regionQuery(dmat, points, currentP, eps);
            if (result.size() >= minPts) {
                for (int i = 0; i < result.size(); ++i) {
                    Point resultP = result.get(i);
                    if (resultP.clusterId != -2 && resultP.clusterId != -1) continue;
                    if (resultP.clusterId == -2) {
                        seeds.add(resultP);
                    }
                    this.changeClusterId(resultP, clusterId);
                }
            }
            seeds.remove(currentP);
        }
        return true;
    }

    private ArrayList<Point> regionQuery(DistanceMatrix dmat, ArrayList<Point> points, Point p, float eps) {
        ArrayList<Point> query = new ArrayList<Point>();
        for (int i = 0; i < points.size(); ++i) {
            if (!(dmat.getDistance(p.id, points.get((int)i).id) <= eps)) continue;
            query.add(points.get(i));
        }
        return query;
    }

    private void changeClusterId(Point p, int id) {
        p.clusterId = id;
    }

    private void changeClusterIds(ArrayList<Point> points, int id) {
        for (Point p : points) {
            p.clusterId = id;
        }
    }

    private int nextId(int id) {
        return ++id;
    }

    @Override
    public AbstractMatrix getCentroids() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getEps() {
        return this.eps;
    }

    public int getNrNeigh() {
        return this.nrNeighbors;
    }

    class Point {
        public static final int UNCLASSIFIED = -2;
        public static final int NOISE = -1;
        public int id = 0;
        public int clusterId = -2;

        public Point(int id) {
            this.id = id;
        }
    }
}

