/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.isodata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import simpletree.datamining.clustering.Clustering;
import simpletree.datamining.clustering.isodata.Group;
import simpletree.datamining.clustering.isodata.Utils;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;

public class IsoData
extends Clustering {
    private int dimension;
    private Group[] groups;
    private AbstractMatrix points;
    private int k;
    private int minNumThres;
    private float std_deviationThres;
    private float minDistanceThres;
    private int maxMergeNumsThres;
    private float totalMeanDistance;
    private int maxIters;
    private AbstractDissimilarity diss;

    public IsoData(Group[] groups, AbstractMatrix points, int k, int minNumThres, float std_deviationThres, float minDistanceThres, int maxMergeNumsThres, int maxIters, AbstractDissimilarity diss) {
        super(0);
        this.groups = groups;
        this.points = points;
        this.k = k;
        this.minNumThres = minNumThres;
        this.std_deviationThres = std_deviationThres;
        this.minDistanceThres = minDistanceThres;
        this.maxMergeNumsThres = maxMergeNumsThres;
        this.maxIters = maxIters;
        this.dimension = points.getDimensions();
        this.diss = diss;
    }

    public void run() {
        int nIters = 1;
        while (nIters <= this.maxIters) {
            boolean splitted;
            System.out.println("--------Iteration: " + nIters + "-------");
            this.assignGroups();
            this.printGroups();
            this.purgeGroups();
            this.updateMeans();
            if (nIters == this.maxIters) {
                this.minDistanceThres = 0.0f;
            } else if ((this.groups.length <= this.k / 2 || nIters % 2 == 1 && this.groups.length < this.k * 2) && (splitted = this.splitGroups())) {
                ++nIters;
                continue;
            }
            this.mergeGroups();
            ++nIters;
        }
        try {
            this.computeGroupsIds();
        }
        catch (Exception e) {
            System.out.println("Deu erro aqui");
        }
        System.out.println("-------------------------Results----------------------------");
        this.assignGroups();
        this.printGroups();
    }

    private void assignGroups() {
        for (int i = 0; i < this.points.getRowCount(); ++i) {
            AbstractVector point = this.points.getRow(i);
            int nearest = -1;
            float minDistance = Float.MAX_VALUE;
            for (int kk = 0; kk < this.groups.length; ++kk) {
                float distance = this.diss.calculate(point, this.groups[kk].getMeanPoint());
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                nearest = kk;
            }
            StringBuffer sbuf = new StringBuffer(point + " ==> " + this.groups[nearest]);
            sbuf.append(", Distance: ").append(minDistance);
            point.setKlass(nearest);
        }
    }

    private void purgeGroups() {
        int i;
        Map<Float, AbstractMatrix> mapGroup2Samples = this.getMapGroup2Samples();
        ArrayList<Group> eligibleGroups = new ArrayList<Group>();
        for (i = 0; i < this.groups.length; ++i) {
            AbstractMatrix groupPoints = mapGroup2Samples.get(Float.valueOf(i));
            if (groupPoints == null) continue;
            if (groupPoints.getRowCount() >= this.minNumThres) {
                eligibleGroups.add(this.groups[i]);
                continue;
            }
            for (int kk = 0; kk < groupPoints.getRowCount(); ++kk) {
                AbstractVector point = groupPoints.getRow(kk);
                point.setKlass(-1.0f);
            }
        }
        for (i = 0; i < eligibleGroups.size(); ++i) {
            Group group = (Group)eligibleGroups.get(i);
            AbstractMatrix groupPoints = mapGroup2Samples.get(Float.valueOf(group.getNumber()));
            for (int kk = 0; kk < groupPoints.getRowCount(); ++kk) {
                AbstractVector point = groupPoints.getRow(kk);
                point.setKlass(i);
            }
            group.setNumber(i);
        }
        this.groups = new Group[eligibleGroups.size()];
        eligibleGroups.toArray(this.groups);
    }

    private boolean splitGroups() {
        int i;
        boolean splitted = false;
        ArrayList<Group> groupList = new ArrayList<Group>();
        Map<Float, AbstractMatrix> mapGroup2Samples = this.getMapGroup2Samples();
        for (i = 0; i < this.groups.length; ++i) {
            AbstractMatrix groupPoints = mapGroup2Samples.get(Float.valueOf(i));
            float[] meanVals = this.groups[i].getMeanPoint().getValues();
            float[] sum = new float[this.dimension];
            for (int kk = 0; kk < groupPoints.getRowCount(); ++kk) {
                AbstractVector point = groupPoints.getRow(kk);
                float[] values = point.getValues();
                for (int j = 0; j < this.dimension; ++j) {
                    int n = j;
                    sum[n] = sum[n] + (values[j] - meanVals[j]) * (values[j] - meanVals[j]);
                }
            }
            StringBuffer sbuf = new StringBuffer("groups[" + (i + 1) + "] Standard Deviation (");
            float[] std_deviationVector = new float[this.dimension];
            int max = -1;
            float maxItem = Float.MIN_VALUE;
            for (int j = 0; j < this.dimension; ++j) {
                float std_deviation;
                std_deviationVector[j] = std_deviation = (float)Math.sqrt(sum[j] / (float)groupPoints.getRowCount());
                if (std_deviation > maxItem) {
                    max = j;
                    maxItem = std_deviation;
                }
                sbuf.append(std_deviation);
                if (j >= this.dimension - 1) continue;
                sbuf.append(", ");
            }
            sbuf.append("), \u00d7\u00ee\u00b4\u00f3\u00b7\u00d6\u00c1\u00bf\u00ce\u00aa\u00a3\u00ba").append(maxItem).append(", ");
            boolean flag = false;
            if (maxItem > this.std_deviationThres && (this.groups.length <= this.k / 2 || this.groups[i].getMeanDistance() > this.totalMeanDistance && groupPoints.getRowCount() > 2 * this.minNumThres)) {
                splitted = true;
                flag = true;
                float delta = 0.5f * maxItem;
                float[] meanVals1 = this.cloneArray(meanVals);
                int n = max;
                meanVals1[n] = meanVals1[n] + delta;
                DenseVector meanPoint1 = new DenseVector(meanVals1, -1);
                Group group1 = new Group(groupList.size());
                group1.setMeanPoint(meanPoint1);
                groupList.add(group1);
                float[] meanVals2 = this.cloneArray(meanVals);
                int n2 = max;
                meanVals2[n2] = meanVals2[n2] - delta;
                DenseVector meanPoint2 = new DenseVector(meanVals2, -1);
                Group group2 = new Group(groupList.size());
                group2.setMeanPoint(meanPoint2);
                groupList.add(group2);
            }
            if (flag) continue;
            this.groups[i].setNumber(groupList.size());
            groupList.add(this.groups[i]);
        }
        if (splitted) {
            for (i = 0; i < groupList.size(); ++i) {
                ((Group)groupList.get(i)).setNumber(i);
            }
            this.groups = new Group[groupList.size()];
            groupList.toArray(this.groups);
        } else {
            System.out.println("\u00b7\u00d6\u00c1\u00d1\u00cc\u00f5\u00bc\u00fe\u00b2\u00bb\u00c2\u00fa\u00d7\u00e3\u00a3\u00a1");
        }
        return splitted;
    }

    private void mergeGroups() {
        int i;
        class GroupDistance
        implements Comparable<GroupDistance> {
            int from;
            int to;
            float distance;

            public GroupDistance(int from, int to, float distance) {
                this.from = from;
                this.to = to;
                this.distance = distance;
            }

            @Override
            public int compareTo(GroupDistance that) {
                if (this.distance < that.distance) {
                    return -1;
                }
                if (this.distance == that.distance) {
                    return 0;
                }
                return 1;
            }
        }
        GroupDistance groupDistance;
        if (this.groups.length < 2) {
            return;
        }
        ArrayList<GroupDistance> groupDistances = new ArrayList<GroupDistance>();
        for (int i2 = 0; i2 < this.groups.length - 1; ++i2) {
            Group iGroup = this.groups[i2];
            for (int j = i2 + 1; j < this.groups.length; ++j) {
                Group jGroup = this.groups[j];
                float distance = this.diss.calculate(iGroup.getMeanPoint(), jGroup.getMeanPoint());
                System.out.println("Distance [Group " + i2 + " - Group " + j + "]: " + distance);
                if (!(distance < this.minDistanceThres)) continue;
                groupDistance = new GroupDistance(i2, j, distance);
                groupDistances.add(groupDistance);
            }
        }
        int size = Math.min(groupDistances.size(), this.maxMergeNumsThres);
        if (size < 1) {
            return;
        }
        Collections.sort(groupDistances);
        StringBuilder sbuf = new StringBuilder("Merging groups...");
        for (GroupDistance distance : groupDistances) {
            sbuf.append("D(").append(distance.from).append(",").append(distance.to).append(") = ").append(distance.distance).append("  ");
        }
        System.out.println(sbuf);
        LinkedList<Group> groupList = new LinkedList<Group>(Arrays.asList(this.groups));
        Map<Float, AbstractMatrix> mapGroup2Samples = this.getMapGroup2Samples();
        for (i = 0; i < size; ++i) {
            groupDistance = (GroupDistance)groupDistances.get(i);
            Group group1 = this.groups[groupDistance.from];
            Group group2 = this.groups[groupDistance.to];
            int n1 = mapGroup2Samples.get(Float.valueOf(group1.getNumber())).getRowCount();
            int n2 = mapGroup2Samples.get(Float.valueOf(group2.getNumber())).getRowCount();
            int total = n1 + n2;
            if (!groupList.contains(group1) || !groupList.contains(group2)) continue;
            groupList.remove(group1);
            groupList.remove(group2);
            float[] meanValues = new float[this.dimension];
            float[] meanValues1 = group1.getMeanPoint().getValues();
            float[] meanValues2 = group2.getMeanPoint().getValues();
            for (int j = 0; j < this.dimension; ++j) {
                meanValues[j] = (meanValues1[j] * (float)n1 + meanValues2[j] * (float)n2) / (float)total;
            }
            DenseVector meanPoint = new DenseVector(meanValues, -1);
            Group group = new Group(groupList.size());
            group.setMeanPoint(meanPoint);
            groupList.add(group);
        }
        for (i = 0; i < groupList.size(); ++i) {
            ((Group)groupList.get(i)).setNumber(i);
        }
        this.groups = new Group[groupList.size()];
        groupList.toArray(this.groups);
    }

    private void printGroups() {
        StringBuilder sbuf = new StringBuilder("- List of Groups: \n");
        for (int i = 0; i < this.groups.length; ++i) {
            ArrayList<Integer> pointNumbers = new ArrayList<Integer>();
            for (int kk = 0; kk < this.points.getRowCount(); ++kk) {
                if (this.points.getRow(kk).getKlass() != (float)i) continue;
                pointNumbers.add(this.points.getRow(kk).getId());
            }
            sbuf.append("group ").append(i + 1).append(": " + this.groups[i].getSize() + "\n");
        }
        System.out.println(sbuf);
    }

    private void updateMeans() {
        StringBuilder sbuf = new StringBuilder("Updating mean distance...");
        int pointCount = 0;
        float totalDistance = 0.0f;
        Map<Float, AbstractMatrix> mapGroup2Samples = this.getMapGroup2Samples();
        for (int i = 0; i < this.groups.length; ++i) {
            AbstractMatrix groupPoints = mapGroup2Samples.get(Float.valueOf(i));
            if (groupPoints.getRowCount() == 0) continue;
            float[] values = new float[this.dimension];
            for (int kk = 0; kk < groupPoints.getRowCount(); ++kk) {
                AbstractVector point = groupPoints.getRow(kk);
                float[] vv = point.getValues();
                for (int j = 0; j < this.dimension; ++j) {
                    int n = j;
                    values[n] = values[n] + vv[j];
                }
            }
            int j = 0;
            while (j < this.dimension) {
                int n = j++;
                values[n] = values[n] / (float)groupPoints.getRowCount();
            }
            DenseVector meanPoint = new DenseVector(values, -1);
            meanPoint.setKlass(i);
            this.groups[i].setMeanPoint(meanPoint);
            float groupDistance = 0.0f;
            for (int kk = 0; kk < groupPoints.getRowCount(); ++kk) {
                AbstractVector point = groupPoints.getRow(kk);
                groupDistance += this.diss.calculate(point, meanPoint);
            }
            float meanDistance = groupDistance / (float)groupPoints.getRowCount();
            this.groups[i].setMeanDistance(meanDistance);
            sbuf.append(this.groups[i]).append(", Mean distance(").append(meanDistance).append("), ");
            pointCount += groupPoints.getRowCount();
            totalDistance += groupDistance;
        }
        this.totalMeanDistance = pointCount != 0 ? totalDistance / (float)pointCount : 0.0f;
    }

    private Map<Float, AbstractMatrix> getMapGroup2Samples() {
        HashMap<Float, AbstractMatrix> mapGroup2Samples = new HashMap<Float, AbstractMatrix>();
        for (int i = 0; i < this.points.getRowCount(); ++i) {
            Utils.hashObject(Float.valueOf(this.points.getRow(i).getKlass()), this.points.getRow(i), mapGroup2Samples);
        }
        return mapGroup2Samples;
    }

    private void computeGroupsIds() {
        for (int i = 0; i < this.points.getRowCount(); ++i) {
            if ((int)this.points.getRow(i).getKlass() < this.groups.length) {
                this.groups[(int)this.points.getRow(i).getKlass()].addId(i);
                continue;
            }
            System.out.println("Id not assigned: " + this.points.getRow(i) + " : " + (int)this.points.getRow(i).getKlass() + " (Length of groups:" + this.groups.length + ")");
        }
    }

    private float[] cloneArray(float[] v) {
        float[] newArray = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            newArray[i] = v[i];
        }
        return newArray;
    }

    public static void main(String[] args) throws Exception {
        String file = "D:\\Dropbox\\MaterialTestes\\Imagem\\ImagensCorel.data";
        AbstractMatrix points = Utils.readSamplePoints(file);
        Group[] groups = new Group[2];
        int idx = 0;
        groups[idx] = new Group(idx);
        groups[idx].setMeanPoint(points.getRow(0));
        groups[++idx] = new Group(idx);
        groups[idx].setMeanPoint(points.getRow(1));
        ++idx;
        int k = 4;
        int minNumThres = 1;
        float std_deviationThres = 1.0E-4f;
        float minDistanceThres = 4.0E-4f;
        int maxMergeNumsThres = 1;
        int maxIters = 10;
        IsoData isodata = new IsoData(groups, points, k, minNumThres, std_deviationThres, minDistanceThres, maxMergeNumsThres, maxIters, DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN));
        isodata.run();
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(AbstractDissimilarity diss, AbstractMatrix matrix) throws IOException {
        this.run();
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < this.groups.length; ++i) {
            result.add(this.groups[i].getIds());
        }
        return result;
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractMatrix getCentroids() {
        DenseMatrix centroids = new DenseMatrix();
        for (int i = 0; i < this.groups.length; ++i) {
            ((AbstractMatrix)centroids).addRow(this.groups[i].getMeanPoint());
        }
        return centroids;
    }
}

