/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.javaml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.javaml.clustering.KMedoids;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;
import net.sf.javaml.distance.CosineDistance;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;
import simpletree.datamining.clustering.Clustering;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.CosineBased;
import simpletree.distance.dissimilarity.Euclidean;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;

public class KmedoidsJavaML
extends Clustering {
    private KMedoids kmedoids;
    private final int nrClusters;
    private AbstractMatrix centroids;
    private List<Integer> medoids;

    public KmedoidsJavaML(int nrClusters) throws Exception {
        super(nrClusters);
        this.nrClusters = nrClusters;
    }

    private Dataset transformAbstractMatrixInstances(AbstractMatrix matrix) {
        DefaultDataset dataset = new DefaultDataset();
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            float[] rowValues = matrix.getRow(i).getValues();
            double[] instanceValues = new double[rowValues.length];
            for (int j = 0; j < matrix.getDimensions(); ++j) {
                instanceValues[j] = rowValues[j];
            }
            DenseInstance instance = new DenseInstance(instanceValues);
            dataset.add((Instance)instance);
        }
        return dataset;
    }

    private DistanceMeasure getDistanceFunction(AbstractDissimilarity diss) {
        if (diss instanceof Euclidean) {
            return new EuclideanDistance();
        }
        if (diss instanceof CosineBased) {
            return new CosineDistance();
        }
        return null;
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(AbstractDissimilarity diss, AbstractMatrix matrix) throws IOException {
        ArrayList<ArrayList<Integer>> list = new ArrayList<ArrayList<Integer>>();
        Dataset dataset = this.transformAbstractMatrixInstances(matrix);
        try {
            this.kmedoids = new KMedoids(this.nrClusters, 100, this.getDistanceFunction(diss));
            Dataset[] clusters = this.kmedoids.cluster(dataset);
            this.centroids = this.computeCentroids(clusters);
            for (Dataset cluster : clusters) {
                ArrayList<Integer> clusterElements = new ArrayList<Integer>();
                for (int i = 0; i < cluster.size(); ++i) {
                    clusterElements.add(((Instance)cluster.get(i)).getID());
                }
                list.add(clusterElements);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(KmedoidsJavaML.class.getName()).log(Level.SEVERE, null, ex);
        }
        return list;
    }

    private AbstractMatrix computeCentroids(Dataset[] clusters) {
        DenseMatrix centroidsMatrix = new DenseMatrix();
        for (int i = 0; i < clusters.length; ++i) {
            float[] clusterCentroid = new float[clusters[i].instance(i).noAttributes()];
            Arrays.fill(clusterCentroid, 0.0f);
            for (int j = 0; j < clusters[i].size(); ++j) {
                Instance instance = (Instance)clusters[i].get(j);
                int t = 0;
                while (j < clusterCentroid.length) {
                    int n = t;
                    clusterCentroid[n] = (float)((double)clusterCentroid[n] + instance.value(t));
                    ++t;
                }
            }
            for (int t = 0; t < clusterCentroid.length; ++t) {
                clusterCentroid[t] = clusterCentroid[t] / (float)clusters[i].size();
            }
            DenseVector centroid = new DenseVector(clusterCentroid, i);
            ((AbstractMatrix)centroidsMatrix).addRow(centroid);
        }
        return centroidsMatrix;
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractMatrix getCentroids() {
        return this.centroids;
    }
}

