/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.multiscale;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.FloatBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import simpletree.datamining.clustering.Clustering;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.datamining.clustering.multiscale.MultiscaleClustering;
import simpletree.datamining.clustering.multiscale.MultiscaleData;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseVector;

public class ClusterIO {
    private static void writeBinaryHeader(MultiscaleData clusterData, RandomAccessFile out) throws IOException {
        out.writeFloat(clusterData.getVersion());
        if (clusterData.getMatrixName() == null || clusterData.getMatrixName().isEmpty()) {
            out.writeInt(0);
        } else {
            out.writeInt(clusterData.getMatrixName().length());
            out.writeBytes(clusterData.getMatrixName());
        }
        out.writeInt(clusterData.getDissimilarityName().length());
        out.writeBytes(clusterData.getDissimilarityName());
        out.writeInt(clusterData.getMaxClusterId());
    }

    private static MultiscaleData readBinaryHeader(MultiscaleData clusterData, MappedByteBuffer in) throws IOException {
        clusterData.setVersion(in.getFloat());
        int inputFileLength = in.getInt();
        if (inputFileLength != 0) {
            byte[] inputFileBytes = new byte[inputFileLength];
            in.get(inputFileBytes);
            clusterData.setMatrixName(new String(inputFileBytes));
        }
        int dissMetricLength = in.getInt();
        byte[] dissMetricBytes = new byte[dissMetricLength];
        in.get(dissMetricBytes);
        clusterData.setDissimilarityName(new String(dissMetricBytes));
        clusterData.setMaxClusterId(in.getInt());
        return clusterData;
    }

    public static MultiscaleData writeBinaryFile(MultiscaleData clusterData, String filePath) throws FileNotFoundException, IOException {
        HashMap<Integer, Long> clusterFileMap = new HashMap<Integer, Long>();
        List<Cluster> clusterList = clusterData.getClusters();
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        int maxClusterId = Integer.MIN_VALUE;
        Stack<Cluster> clusterStack = new Stack<Cluster>();
        for (Cluster cluster : clusterList) {
            clusterStack.push(cluster);
            while (!clusterStack.isEmpty()) {
                Cluster currentCluster = (Cluster)clusterStack.pop();
                if (currentCluster.getId() > maxClusterId) {
                    maxClusterId = currentCluster.getId();
                }
                if (currentCluster.getSubClusterList().isEmpty()) continue;
                clusterStack.addAll(currentCluster.getSubClusterList());
            }
        }
        clusterData.setMaxClusterId(maxClusterId);
        RandomAccessFile out = new RandomAccessFile(filePath, "rw");
        ClusterIO.writeBinaryHeader(clusterData, out);
        out.writeInt(clusterList.size());
        for (Cluster cluster : clusterList) {
            out.writeInt(cluster.getId());
        }
        for (Cluster cluster : clusterList) {
            ClusterIO.writeBinaryCluster(out, cluster, clusterFileMap);
        }
        ClusterIO.writeBinaryFileMap(out, clusterFileMap);
        out.close();
        clusterData.setMap(clusterFileMap);
        clusterData.setFilename(filePath);
        return clusterData;
    }

    private static void writeBinaryFileMap(RandomAccessFile out, HashMap<Integer, Long> clusterPointerMap) throws FileNotFoundException, IOException {
        for (Map.Entry<Integer, Long> e : clusterPointerMap.entrySet()) {
            int clusterId = e.getKey();
            long mapPosition = e.getValue();
            out.writeInt(clusterId);
            out.writeLong(mapPosition);
        }
        out.writeInt(clusterPointerMap.size());
    }

    private static HashMap<Integer, Long> readBinaryFileMap(MappedByteBuffer in) throws FileNotFoundException, IOException {
        HashMap<Integer, Long> pointerMap = new HashMap<Integer, Long>();
        int fileSize = in.capacity();
        in.position(fileSize - 4);
        int listSize = in.getInt();
        int blockSize = 12;
        in.position(fileSize - 4 - blockSize * listSize);
        for (int i = 0; i < listSize; ++i) {
            int clusterId = in.getInt();
            long position = in.getLong();
            pointerMap.put(clusterId, position);
        }
        return pointerMap;
    }

    private static void writeBinaryCluster(RandomAccessFile out, Cluster cluster, HashMap<Integer, Long> clusterPointerMap) throws IOException {
        clusterPointerMap.put(cluster.getId(), out.getFilePointer());
        out.writeInt(cluster.getId());
        out.writeInt(cluster.getLevelHeight());
        out.writeInt(cluster.getSize());
        out.writeInt(cluster.getItemList().size());
        for (Integer elementId : cluster.getItemList()) {
            out.writeInt(elementId);
        }
        out.writeInt(cluster.getMedoidList().size());
        for (Integer medoidId : cluster.getMedoidList()) {
            out.writeInt(medoidId);
        }
        out.writeInt(cluster.getCentroidVector().size());
        float[] centroidValues = cluster.getCentroidVector().toArray();
        Object object = centroidValues;
        int n = ((float[])object).length;
        for (int i = 0; i < n; ++i) {
            Float value = Float.valueOf(object[i]);
            out.writeFloat(value.floatValue());
        }
        out.writeInt(cluster.getSubClusterList().size());
        object = cluster.getSubClusterList().iterator();
        while (object.hasNext()) {
            Cluster subCluster = (Cluster)object.next();
            out.writeInt(subCluster.getId());
            out.writeInt(subCluster.getSize());
        }
        for (Cluster subCluster : cluster.getSubClusterList()) {
            ClusterIO.writeBinaryCluster(out, subCluster, clusterPointerMap);
        }
    }

    public static MultiscaleData readBinaryFile(String filePath, boolean skipSubClusters) throws FileNotFoundException, IOException {
        long init = System.currentTimeMillis();
        File file = new File(filePath);
        RandomAccessFile inRAF = new RandomAccessFile(file, "r");
        FileChannel fc = inRAF.getChannel();
        MappedByteBuffer in = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        HashMap<Integer, Long> clusterMap = ClusterIO.readBinaryFileMap(in);
        in.position(0);
        MultiscaleData clusterData = new MultiscaleData();
        ClusterIO.readBinaryHeader(clusterData, in);
        int clusterListSize = in.getInt();
        ArrayList<Cluster> clusterList = new ArrayList<Cluster>();
        for (long i = 0L; i < (long)clusterListSize; ++i) {
            int clusterId = in.getInt();
            if (!clusterMap.containsKey(clusterId)) continue;
            int currentPos = in.position();
            long newClusterPos = clusterMap.get(clusterId);
            Cluster newCluster = ClusterIO.readBinaryCluster(in, (int)newClusterPos, skipSubClusters);
            clusterList.add(newCluster);
            in.position(currentPos);
        }
        inRAF.close();
        long end = System.currentTimeMillis();
        long diff = end - init;
        System.out.println("Time spent (Cluster Disk Read) -> " + (float)diff / 1000.0f + " seconds.");
        clusterData.setMap(clusterMap);
        clusterData.setClusters(clusterList);
        return clusterData;
    }

    public static Cluster readBinaryCluster(String fileName, long fileOffset, boolean skipSubClusters) throws IOException {
        File file = new File(fileName);
        RandomAccessFile inRAF = new RandomAccessFile(file, "r");
        FileChannel fc = inRAF.getChannel();
        MappedByteBuffer in = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        Cluster cluster = ClusterIO.readBinaryCluster(in, (int)fileOffset, skipSubClusters);
        return cluster;
    }

    private static Cluster readBinaryCluster(MappedByteBuffer in, int fileOffset, boolean skipSubClusters) throws IOException {
        long initTime = System.currentTimeMillis();
        in.position(fileOffset);
        Cluster cluster = ClusterIO.readBinaryCluster(in, skipSubClusters);
        long endTime = System.currentTimeMillis();
        long diffTime = endTime - initTime;
        System.out.printf("Time spent (Cluster #%d Read) -> %f seconds.\n", fileOffset, Float.valueOf((float)diffTime / 1000.0f));
        return cluster;
    }

    private static Cluster readBinaryCluster(MappedByteBuffer in, boolean skipSubClusters) throws IOException {
        int clusterId = in.getInt();
        Cluster cluster = new Cluster(clusterId);
        int clusterLevelHeight = in.getInt();
        cluster.setLevelHeight(clusterLevelHeight);
        int clusterSize = in.getInt();
        cluster.setSize(clusterSize);
        int itemListSize = in.getInt();
        ArrayList<Integer> itemList = new ArrayList<Integer>();
        for (long i = 0L; i < (long)itemListSize; ++i) {
            itemList.add(in.getInt());
        }
        int medoidListSize = in.getInt();
        ArrayList<Integer> medoidList = new ArrayList<Integer>();
        for (long i = 0L; i < (long)medoidListSize; ++i) {
            medoidList.add(in.getInt());
        }
        int centroidSize = in.getInt();
        float[] centroidValues = new float[centroidSize];
        FloatBuffer floatBuffer = in.asFloatBuffer();
        floatBuffer.get(centroidValues);
        DenseVector centroidVector = new DenseVector(centroidValues);
        cluster.setCentroidVector(centroidVector);
        in.position(in.position() + floatBuffer.position() * 4);
        int subClusterListSize = in.getInt();
        ArrayList<Cluster> subClusterList = new ArrayList<Cluster>();
        for (long i = 0L; i < (long)subClusterListSize; ++i) {
            int subClusterId = in.getInt();
            Cluster subCluster = new Cluster(subClusterId);
            int subClusterSize = in.getInt();
            subCluster.setSize(subClusterSize);
            if (!skipSubClusters) {
                int n = in.position();
            }
            subClusterList.add(subCluster);
        }
        cluster.setItemList(itemList);
        cluster.setMedoidList(medoidList);
        cluster.setSubClusterList(subClusterList);
        return cluster;
    }

    private static void testWriting() throws IOException, Exception {
        AbstractMatrix matrix = MatrixFactory.getInstance("D:\\ImagensCorel.data");
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        Clustering technique = MultiscaleClustering.getClusteringTechnique(0, "20", diss, matrix);
        MultiscaleClustering clus = new MultiscaleClustering();
        List<Cluster> clusterList = clus.clusterize(matrix, technique, diss, 40, false, 10);
        MultiscaleData clusterData = new MultiscaleData();
        clusterData.setMatrixName("ImagensCorel.data");
        clusterData.setDissimilarityName(DissimilarityFactory.DissimilarityType.EUCLIDEAN.name());
        clusterData.setClusters(clusterList);
        ClusterIO.writeBinaryFile(clusterData, "D:\\ImagensCorel_20_40_10.clus");
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, Exception {
        File file = new File("D:\\f2.clus");
        RandomAccessFile inRAF = new RandomAccessFile(file, "r");
        FileChannel fc = inRAF.getChannel();
        MappedByteBuffer in = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        int inteiro = in.getInt();
        inRAF.close();
        System.out.println("FIM");
    }
}

