/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.normalization;

import java.io.IOException;
import java.util.Arrays;
import simpletree.datamining.normalization.AbstractNormalization;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.matrix.sparse.SparseMatrix;

public class EqualizeColumns
extends AbstractNormalization {
    private static final int nrbins = 1000;

    @Override
    public AbstractMatrix execute(AbstractMatrix matrix) throws IOException {
        assert (matrix.getRowCount() > 0) : "More than zero vectors must be used!";
        Object points = null;
        if (matrix instanceof DenseMatrix) {
            points = new float[matrix.getRowCount()][];
            for (int i = 0; i < ((float[][])points).length; ++i) {
                points[i] = matrix.getRow(i).getValues();
                matrix.getRow(i).shouldUpdateNorm();
            }
        } else {
            points = matrix.toMatrix();
        }
        for (int j = 0; j < matrix.getDimensions(); ++j) {
            int index;
            int i;
            float[] hist = new float[1000];
            Arrays.fill(hist, 0.0f);
            float min = Float.POSITIVE_INFINITY;
            float max = Float.NEGATIVE_INFINITY;
            for (i = 0; i < ((float[][])points).length; ++i) {
                if (points[i][j] > max) {
                    max = points[i][j];
                }
                if (!(points[i][j] < min)) continue;
                min = points[i][j];
            }
            for (i = 0; i < ((float[][])points).length; ++i) {
                if (max > min) {
                    index = (int)((points[i][j] - min) / (max - min) * 999.0f);
                    hist[index] = hist[index] + 1.0f;
                    continue;
                }
                hist[0] = hist[0] + 1.0f;
            }
            hist[0] = hist[0] / (float)((float[][])points).length;
            for (i = 1; i < hist.length; ++i) {
                hist[i] = hist[i - 1] + hist[i] / (float)((float[][])points).length;
            }
            for (i = 0; i < ((float[][])points).length; ++i) {
                if (max > min) {
                    index = (int)((points[i][j] - min) / (max - min) * 999.0f);
                    points[i][j] = hist[index] * (max - min) + min;
                    continue;
                }
                points[i][j] = 0.0f;
            }
        }
        if (matrix instanceof SparseMatrix) {
            DenseMatrix eqmatrix = new DenseMatrix();
            eqmatrix.setAttributes(matrix.getAttributes());
            for (int i = 0; i < matrix.getRowCount(); ++i) {
                AbstractVector oldv = matrix.getRow(i);
                ((AbstractMatrix)eqmatrix).addRow(new DenseVector(points[i], oldv.getId(), oldv.getKlass()));
            }
            return eqmatrix;
        }
        return matrix;
    }
}

