/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.normalization;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.normalization.AbstractNormalization;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;

public class ZScore
extends AbstractNormalization {
    @Override
    public AbstractMatrix execute(AbstractMatrix matrix) throws IOException {
        AbstractMatrix normalizedMatrix = null;
        try {
            normalizedMatrix = (AbstractMatrix)matrix.clone();
            int columnLength = matrix.getRow(0).getValues().length;
            for (int j = 0; j < columnLength - 1; ++j) {
                float mean = this.getMean(matrix, j);
                float variance = this.getVariance(matrix, j);
                float stdDev = (float)Math.sqrt(variance);
                for (int i = 0; i < matrix.getRowCount() - 1; ++i) {
                    AbstractVector abstractVector = matrix.getRow(i);
                    float value = abstractVector.getValue(j);
                    float z = stdDev != 0.0f ? (value - mean) / stdDev : 0.0f;
                    normalizedMatrix.getRow(i).setValue(j, z);
                }
            }
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(ZScore.class.getName()).log(Level.SEVERE, null, ex);
        }
        return normalizedMatrix;
    }

    private float getMean(AbstractMatrix matrix, int columnIndex) {
        float total = 0.0f;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            total += matrix.getRow(i).getValue(columnIndex);
        }
        float mean = total / (float)matrix.getRowCount();
        return mean;
    }

    private float getVariance(AbstractMatrix matrix, int columnIndex) {
        float mean = this.getMean(matrix, columnIndex);
        float sum = 0.0f;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            sum = (float)((double)sum + Math.pow(matrix.getRow(i).getValue(columnIndex) - mean, 2.0));
        }
        float variance = sum / (float)(matrix.getRowCount() - 1);
        return variance;
    }
}

