/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.sampling;

import java.io.IOException;
import simpletree.datamining.sampling.Sampling;
import simpletree.datamining.sampling.SamplingParamView;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Technique.L-MMDS", name="Random Sampling", description="Get a random sampling of a given matrix.")
public class SamplingComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private int samplesize = 0;
    private Sampling.SampleType sampletype = Sampling.SampleType.RANDOM;
    private transient AbstractMatrix matrix;
    private transient AbstractMatrix samplematrix;
    private transient SamplingParamView paramview;

    public void execute() throws IOException {
        if (this.matrix == null) {
            throw new IOException("A points matrix should be provided.");
        }
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
        Sampling sampling = new Sampling(this.sampletype, this.samplesize);
        this.samplematrix = sampling.execute(this.matrix, diss);
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public AbstractMatrix output() {
        return this.samplematrix;
    }

    public void reset() {
        this.matrix = null;
        this.samplematrix = null;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new SamplingParamView(this);
        }
        return this.paramview;
    }

    public void setSampleSize(int samplesize) {
        this.samplesize = samplesize;
    }

    public int getSampleSize() {
        return this.samplesize;
    }

    public Sampling.SampleType getSampleType() {
        return this.sampletype;
    }

    public void setSampleType(Sampling.SampleType sampletype) {
        this.sampletype = sampletype;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }
}

