/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.weighing;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.datamining.weighing.AttributeWeighingParamView;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Transformation", name="Attribute Weighing", description="Transform the data using a weighing process.")
public class AttributeWeighingComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient ArrayList<Float> weights;
    private transient AttributeWeighingParamView paramview;
    private transient AbstractMatrix input;
    private transient AbstractMatrix output;

    public void execute() throws IOException {
        Object points = null;
        if (this.input instanceof DenseMatrix) {
            points = new float[this.input.getRowCount()][];
            for (int i = 0; i < ((float[][])points).length; ++i) {
                points[i] = this.input.getRow(i).getValues();
            }
        } else {
            points = this.input.toMatrix();
        }
        float[][] wPoints = new float[((float[][])points).length][this.input.getDimensions()];
        for (int col = 0; col < this.input.getDimensions(); ++col) {
            float weight = this.weights.get(col).floatValue();
            for (int row = 0; row < this.input.getRowCount(); ++row) {
                wPoints[row][col] = weight * points[row][col];
            }
        }
        this.output = new DenseMatrix();
        for (int i = 0; i < this.input.getRowCount(); ++i) {
            this.output.addRow(new DenseVector(wPoints[i], this.input.getRow(i).getId(), this.input.getRow(i).getKlass()));
        }
        this.output.setAttributes(this.input.getAttributes());
    }

    public void input(@Param(name="points matrix") AbstractMatrix input) {
        this.input = input;
    }

    public AbstractMatrix output() {
        return this.output;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new AttributeWeighingParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.input = null;
        this.output = null;
    }

    public AbstractMatrix getInput() {
        return this.input;
    }

    public void setWeights(ArrayList<Float> weights) {
        this.weights = weights;
    }
}

