/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.DistanceMatrixWriterParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Distance.Output", name="Distance Matrix writer", description="Write a Distance Matrix to a file.")
public class DistanceMatrixWriterComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient DistanceMatrixWriterParamView paramview;
    private transient DistanceMatrix dmat;

    public void execute() throws IOException {
        if (this.filename.trim().length() <= 0) {
            throw new IOException("A distance matrix file name must be provided to write.");
        }
        this.dmat.save(this.filename);
    }

    public void input(@Param(name="distance matrix") DistanceMatrix dmat) {
        this.dmat = dmat;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new DistanceMatrixWriterParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.dmat = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

