/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.converter;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.converter.DistanceMatrixConverterParamView;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Distance.Calculator", name="Distance Matrix converter", description="Read a Points Matrix and builds a distance matrix.")
public class DistanceMatrixConverterComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient DistanceMatrixConverterParamView paramview;
    private transient AbstractMatrix matrix;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;

    public void execute() {
        try {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            DistanceMatrix dm = new DistanceMatrix(this.matrix, diss);
            dm.save(this.filename);
            JOptionPane.showMessageDialog(null, "Distance Matrix saved.");
        }
        catch (IOException ex) {
            Logger.getLogger(DistanceMatrixConverterComp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new DistanceMatrixConverterParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }
}

