/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.dissimilarity;

import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractVector;

public class CosineBased
implements AbstractDissimilarity {
    @Override
    public float calculate(AbstractVector v1, AbstractVector v2) {
        assert (v1.size() == v2.size()) : "ERROR: vectors of different sizes!";
        float n1 = v1.norm();
        float n2 = v2.norm();
        float cosine = -1.0f;
        if (n1 != 0.0f && n2 != 0.0f) {
            cosine = v1.dot(v2) / (n1 * n2);
            if (cosine > 1.0f) {
                cosine = 1.0f;
            } else if (cosine < -1.0f) {
                cosine = -1.0f;
            }
        } else if (n1 == 0.0f && n2 == 0.0f) {
            cosine = 1.0f;
        }
        return 1.0f - cosine;
    }
}

