/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.histogram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import simpletree.distance.DistanceMatrix;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.PNGFilter;

public class DistanceHistogram
extends JFrame {
    private JFreeChart freechart;
    private JPanel panel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton saveImageButton;

    public DistanceHistogram() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.saveImageButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.saveImageButton.setText("Save Image");
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceHistogram.this.saveImageButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveImageButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceHistogram.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    private void saveImageButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("distance.properties");
            int result = SaveDialog.showSaveDialog(spm, new PNGFilter(), this, "image.png");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                try {
                    BufferedImage image = this.freechart.createBufferedImage(this.panel.getWidth(), this.panel.getHeight());
                    ImageIO.write((RenderedImage)image, "png", new File(filename));
                }
                catch (IOException ex) {
                    Logger.getLogger(DistanceHistogram.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Problems saving the file", 0);
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DistanceHistogram.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public void display(DistanceMatrix dmat, String histogramLabel) {
        this.freechart = this.createChart(this.createDataset(dmat, histogramLabel));
        TextTitle subtitle = new TextTitle(histogramLabel);
        subtitle.setBorder(1.0, 1.0, 1.0, 1.0);
        subtitle.setFont(new Font("Arial", 0, 12));
        this.freechart.addSubtitle((Title)subtitle);
        LegendTitle l = this.freechart.getLegend();
        this.freechart.removeLegend();
        this.panel = new ChartPanel(this.freechart);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setPreferredSize(new Dimension(500, 300));
        this.setSize(new Dimension(500, 300));
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private IntervalXYDataset createDataset(DistanceMatrix dmat, String histogramLabel) {
        HistogramDataset histogramdataset = new HistogramDataset();
        int nrDistances = (dmat.getElementCount() * dmat.getElementCount() - dmat.getElementCount()) / 2;
        double[] ad = new double[nrDistances];
        int index = 0;
        for (int i = 0; i < dmat.getElementCount() - 1; ++i) {
            for (int j = dmat.getElementCount() - 1; j > i; --j) {
                ad[index] = (dmat.getDistance(i, j) - dmat.getMinDistance()) / (dmat.getMaxDistance() - dmat.getMinDistance());
                ++index;
            }
        }
        histogramdataset.addSeries((Comparable)((Object)histogramLabel), ad, 200, 0.0, 1.0);
        return histogramdataset;
    }

    private JFreeChart createChart(IntervalXYDataset intervalxydataset) {
        JFreeChart chart = ChartFactory.createHistogram((String)"Distance Histogram", (String)"Distances Values", (String)"Occurences", (IntervalXYDataset)intervalxydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        xyplot.setDomainGridlinePaint((Paint)Color.BLACK);
        xyplot.setRangeGridlinePaint((Paint)Color.BLACK);
        xyplot.setOutlinePaint((Paint)Color.BLACK);
        xyplot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        xyplot.setBackgroundPaint((Paint)Color.white);
        xyplot.setDomainCrosshairVisible(true);
        xyplot.setRangeCrosshairVisible(true);
        XYBarRenderer xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
        xybarrenderer.setDrawBarOutline(false);
        return chart;
    }
}

