/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.histogram;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.distance.histogram.DistanceHistogramComp;
import vispipelinebasics.interfaces.AbstractParametersView;

public class DistanceHistogramParamView
extends AbstractParametersView {
    private DistanceHistogramComp comp;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JLabel histogramLabel;
    private JPanel histogramLabelPanel;
    private JTextField histogramLabelTextField;
    private JPanel parametersPanel;

    public DistanceHistogramParamView(DistanceHistogramComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType disstype : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(disstype);
        }
        this.reset();
    }

    private void initComponents() {
        this.parametersPanel = new JPanel();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.histogramLabelPanel = new JPanel();
        this.histogramLabel = new JLabel();
        this.histogramLabelTextField = new JTextField();
        this.setLayout(new BorderLayout());
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("DIstance Histogram Parameters"));
        this.parametersPanel.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.parametersPanel.add((Component)this.dissimilarityPanel, gridBagConstraints);
        this.histogramLabelPanel.setLayout(new FlowLayout(0));
        this.histogramLabel.setText("Label : ");
        this.histogramLabelPanel.add(this.histogramLabel);
        this.histogramLabelTextField.setColumns(10);
        this.histogramLabelTextField.setText("30");
        this.histogramLabelTextField.setMinimumSize(new Dimension(150, 20));
        this.histogramLabelTextField.setPreferredSize(new Dimension(150, 20));
        this.histogramLabelPanel.add(this.histogramLabelTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.parametersPanel.add((Component)this.histogramLabelPanel, gridBagConstraints);
        this.add(this.parametersPanel, "Center");
    }

    public void reset() {
        if (this.comp.isDistanceMatrixProvided()) {
            this.dissimilarityComboBox.setEnabled(false);
        } else {
            this.dissimilarityComboBox.setEnabled(true);
            this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        }
        this.histogramLabelTextField.setText(this.comp.getHistogramLabel());
    }

    public void finished() throws IOException {
        if (!this.comp.isDistanceMatrixProvided()) {
            this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        }
        this.comp.setHistogramLabel(this.histogramLabelTextField.getText());
    }
}

