/*
 * Decompiled with CFR 0.152.
 */
package simpletree.forcelayout;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Edge;
import simpletree.model.GraphInstance;
import simpletree.model.GraphModel;
import simpletree.view.GraphFrame;

public class ForceDirectLayout
implements Runnable {
    private static final float MAX_EDGE_SIZE = 20.0f;
    private static final float MIN_EDGE_SIZE = 5.0f;
    private boolean normalize = true;
    private float max_length;
    private float min_length;
    private ArrayList<Edge> edges;
    private ArrayList<AbstractInstance> instances;
    private GraphModel model;
    private GraphFrame frame;
    private Thread relaxer;

    public ForceDirectLayout(GraphModel model, GraphFrame frame) {
        this.model = model;
        this.frame = frame;
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        int i = 0;
        while (this.relaxer == me) {
            this.relax();
            if (i++ % 5 != 0) continue;
            try {
                this.frame.updateImage();
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    synchronized void relax() {
        if (this.edges != null && this.instances != null) {
            int i;
            for (i = 0; i < this.edges.size(); ++i) {
                Edge e = this.edges.get(i);
                GraphInstance source = (GraphInstance)this.instances.get(e.getSource());
                GraphInstance target = (GraphInstance)this.instances.get(e.getTarget());
                float vx = target.getX() - source.getX();
                float vy = target.getY() - source.getY();
                float len = (float)Math.sqrt(vx * vx + vy * vy);
                float edgeLen = e.getWeight();
                edgeLen = edgeLen != -1.0f && this.normalize ? (edgeLen - this.min_length) / (this.max_length - this.min_length) * 15.0f + 5.0f : 20.0f;
                len = len == 0.0f ? 1.0E-4f : len;
                float f = (edgeLen - len) / (len * 3.0f);
                float dx = f * vx;
                float dy = f * vy;
                target.fdata.dx += dx;
                target.fdata.dy += dy;
                source.fdata.dx += -dx;
                source.fdata.dy += -dy;
            }
            for (i = 0; i < this.instances.size(); ++i) {
                GraphInstance v1 = (GraphInstance)this.instances.get(i);
                float dx = 0.0f;
                float dy = 0.0f;
                for (int j = 0; j < this.instances.size(); ++j) {
                    float vy;
                    if (i == j) continue;
                    GraphInstance v2 = (GraphInstance)this.instances.get(j);
                    float vx = v1.getX() - v2.getX();
                    float len = vx * vx + (vy = v1.getY() - v2.getY()) * vy;
                    if (len == 0.0f) {
                        dx = (float)((double)dx + Math.random());
                        dy = (float)((double)dy + Math.random());
                        continue;
                    }
                    if (!(len < 10000.0f)) continue;
                    dx += vx / len;
                    dy += vy / len;
                }
                float dlen = dx * dx + dy * dy;
                if (!(dlen > 0.0f)) continue;
                dlen = (float)Math.sqrt(dlen) / 2.0f;
                v1.fdata.dx += dx / dlen;
                v1.fdata.dy += dy / dlen;
            }
            for (i = 0; i < this.instances.size(); ++i) {
                GraphInstance v = (GraphInstance)this.instances.get(i);
                float x = v.getX() + Math.max(-5.0f, Math.min(5.0f, v.fdata.dx));
                float y = v.getY() + Math.max(-5.0f, Math.min(5.0f, v.fdata.dy));
                v.setX(x);
                v.setY(y);
                v.fdata.dx /= 2.0f;
                v.fdata.dy /= 2.0f;
            }
        }
    }

    public void start(Connectivity connectivity) {
        if (connectivity != null) {
            this.edges = connectivity.getEdges();
            this.instances = this.model.getInstances();
            this.max_length = Float.MIN_VALUE;
            this.min_length = Float.MAX_VALUE;
            for (Edge e : this.edges) {
                if (e.getWeight() > this.max_length) {
                    this.max_length = e.getWeight();
                }
                if (!(e.getWeight() < this.min_length)) continue;
                this.min_length = e.getWeight();
            }
            this.normalize = this.max_length > this.min_length;
            this.relaxer = new Thread(this);
            this.relaxer.start();
        }
    }

    public void stop() {
        this.relaxer = null;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        this.model.normalizeVertex(this.model.getInstanceSize() * 5 + 10, (float)d.getHeight() / 1.65f);
        this.frame.updateImage();
    }
}

