/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;

public class DistanceElementPair {
    private Float distance;
    private Integer elementId;
    public static Comparator<DistanceElementPair> PairComparator = new Comparator<DistanceElementPair>(){

        @Override
        public int compare(DistanceElementPair o1, DistanceElementPair o2) {
            return o1.compareTo(o2);
        }
    };

    public DistanceElementPair(Float distance, Integer elementId) {
        this.distance = distance;
        this.elementId = elementId;
    }

    public void setDistance(Float distance) {
        this.distance = distance;
    }

    public void setElementId(Integer elementId) {
        this.elementId = elementId;
    }

    public float getDistance() {
        return this.distance.floatValue();
    }

    public int getElementId() {
        return this.elementId;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DistanceElementPair)) {
            return false;
        }
        DistanceElementPair otherPair = (DistanceElementPair)other;
        return this.distance == otherPair.distance && this.elementId == otherPair.elementId;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.distance);
        hash = 97 * hash + Objects.hashCode(this.elementId);
        return hash;
    }

    public int compareTo(DistanceElementPair comparePair) {
        float comparedDistance = this.distance.floatValue() - comparePair.distance.floatValue();
        if (comparedDistance < 0.0f) {
            return -1;
        }
        if (comparedDistance == 0.0f) {
            return 0;
        }
        return 1;
    }

    public static void main(String[] args) {
        ArrayList<DistanceElementPair> pairList = new ArrayList<DistanceElementPair>();
        pairList.add(new DistanceElementPair(Float.valueOf(1.2f), 1));
        pairList.add(new DistanceElementPair(Float.valueOf(1.5f), 2));
        pairList.add(new DistanceElementPair(Float.valueOf(1.9f), 3));
        pairList.add(new DistanceElementPair(Float.valueOf(1.1f), 4));
        Collections.sort(pairList, PairComparator);
        System.out.println("FIM!");
    }
}

