/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseVector;

public class TreeCluster {
    private String newick = "";
    public ClusterType type;
    private int id = 0;
    private int parentId = 0;
    private List<TreeCluster> subClusterList;
    private List<Integer> itemList;
    private List<Integer> medoidList;
    private DenseVector centroidVector;
    private int size;
    private int levelHeight = 1;

    public TreeCluster(int id) {
        this.id = id;
        this.itemList = new ArrayList<Integer>();
        this.subClusterList = new ArrayList<TreeCluster>();
        this.medoidList = new ArrayList<Integer>();
    }

    public TreeCluster clone() {
        TreeCluster newCluster = new TreeCluster(this.id);
        newCluster.itemList.addAll(this.itemList);
        newCluster.medoidList.addAll(this.medoidList);
        newCluster.size = this.size;
        newCluster.levelHeight = this.levelHeight;
        ArrayList<TreeCluster> newSubClusterList = new ArrayList<TreeCluster>();
        if (this.subClusterList != null && !this.subClusterList.isEmpty()) {
            for (TreeCluster subCluster : this.subClusterList) {
                newSubClusterList.add(subCluster.clone());
            }
        }
        newCluster.setSubClusterList(newSubClusterList);
        return newCluster;
    }

    public DenseVector getCentroidVector() {
        return this.centroidVector;
    }

    public String getNewick() {
        return this.newick;
    }

    public void setNewick(String newick) {
        this.newick = newick;
    }

    public void setCentroidVector(DenseVector centroidVector) {
        this.centroidVector = centroidVector;
    }

    public int getLevelHeight() {
        return this.levelHeight;
    }

    public void setLevelHeight(int levelHeight) {
        this.levelHeight = levelHeight;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<TreeCluster> getSubClusterList() {
        return this.subClusterList;
    }

    public void setSubClusterList(List<TreeCluster> subClusterList) {
        this.subClusterList = subClusterList;
    }

    public List<Integer> getItemList() {
        return this.itemList;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setItemList(List<Integer> itemList) {
        this.itemList = itemList;
    }

    public List<Integer> getMedoidList() {
        return this.medoidList;
    }

    public void setMedoidList(ArrayList<Integer> medoidList) {
        this.medoidList = medoidList;
    }

    private List<Integer> getAllItemsRecursive(TreeCluster cluster) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        items.addAll(cluster.itemList);
        for (TreeCluster subCluster : cluster.getSubClusterList()) {
            items.addAll(this.getAllItemsRecursive(subCluster));
        }
        return items;
    }

    public AbstractMatrix getSubMatrix(AbstractMatrix matrix) {
        AbstractMatrix clusterMatrix = null;
        try {
            clusterMatrix = MatrixFactory.getInstance(matrix.getClass());
        }
        catch (IOException ex) {
            Logger.getLogger(TreeCluster.class.getName()).log(Level.SEVERE, null, ex);
        }
        ArrayList<String> labels = new ArrayList<String>();
        List<Integer> itemsIndex = !this.itemList.isEmpty() ? this.itemList : this.getAllItemsRecursive(this);
        if (itemsIndex.size() != this.size) {
            Logger.getLogger(TreeCluster.class.getName()).log(Level.WARNING, "Matrix size and elements list size does not match!");
        }
        for (Integer item : itemsIndex) {
            AbstractVector vector = matrix.getRow(item);
            clusterMatrix.addRow(vector);
            labels.add(matrix.getLabel(item));
        }
        clusterMatrix.setLabels(labels);
        clusterMatrix.setAttributes(matrix.getAttributes());
        return clusterMatrix;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public static enum ClusterType {
        INTERNAL(0),
        LEAF(1);

        int value;

        private ClusterType(int i) {
            this.value = i;
        }

        public int getValue() {
            return this.value;
        }
    }
}

