/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.clustering.Clustering;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.cluster.TreeClusterFile;
import simpletree.io.cluster.TreeMultilevelClustering;
import simpletree.io.file.FileEntry;
import simpletree.io.label.TreeLabel;
import simpletree.io.scalar.TreeScalar;
import simpletree.io.topic.TreeTopic;
import simpletree.io.topic.TreeTopicExtractor;
import simpletree.io.topic.TreeTopicFile;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;

public class SupertreeFile {
    public float version = 1.4f;
    public String filename = "";
    private Map<Integer, FileEntry> entries = new HashMap<Integer, FileEntry>();
    public final Cluster Cluster = new Cluster();
    public final Scalar Scalar = new Scalar();
    public final Label Label = new Label();
    public final Topic Topic;

    public SupertreeFile(String filename) {
        this.filename = filename;
        this.Topic = new Topic(filename);
    }

    private void loadEntries() throws IOException {
        if (!this.entries.isEmpty()) {
            return;
        }
        File file = new File(this.filename);
        if (!file.exists()) {
            try (RandomAccessFile out = new RandomAccessFile(this.filename, "rw");){
                out.writeFloat(this.version);
                out.writeInt(0);
            }
            return;
        }
        try (RandomAccessFile in = new RandomAccessFile(this.filename, "rw");){
            this.version = in.readFloat();
            int numEntries = in.readInt();
            for (int i = 0; i < numEntries; ++i) {
                FileEntry newEntry = new FileEntry(in.readInt());
                newEntry.end = in.readLong();
                newEntry.start = in.getFilePointer();
                this.entries.put(newEntry.type, newEntry);
                in.seek(newEntry.end);
            }
        }
    }

    private void updateEntries() throws FileNotFoundException, IOException {
        try (RandomAccessFile out = new RandomAccessFile(this.filename, "rw");){
            out.seek(0L);
            out.writeFloat(this.version);
            out.writeInt(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                int entryType = out.readInt();
                FileEntry entry = this.entries.get(entryType);
                out.writeLong(entry.end);
                out.seek(entry.end);
            }
        }
    }

    private FileEntry createNewEntry(int code) throws FileNotFoundException, IOException {
        FileEntry newEntry = new FileEntry(code);
        try (RandomAccessFile out = new RandomAccessFile(this.filename, "rw");){
            out.seek(out.length());
            out.writeInt(code);
            out.writeLong(0L);
            newEntry.start = out.getFilePointer();
        }
        return newEntry;
    }

    private static void testImagePointsMatrix() throws IOException {
        AbstractMatrix matrix = MatrixFactory.getInstance("/home/renato/corel1000.data");
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        TreeMultilevelClustering clus = new TreeMultilevelClustering();
        Clustering technique = TreeMultilevelClustering.getClusteringTechnique(0, "10", diss, matrix);
        TreeCluster rootCluster = clus.clusterize(matrix, technique, diss, 100, false, 10);
        String filename = "/home/renato/corel1000.stree";
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
        SupertreeFile stFile = new SupertreeFile(filename);
        stFile.Cluster.Metadata.clusParams = "K = 10, Maxsize = 100";
        stFile.Cluster.Metadata.dimensionality = 128;
        stFile.Cluster.Metadata.dissName = "Euclidean";
        stFile.Cluster.Metadata.inputMatrixName = "Corel1000.data";
        stFile.Cluster.Metadata.inputMatrixSize = matrix.getRowCount();
        stFile.Cluster.Metadata.clusTechnique = "Kmeans";
        stFile.Cluster.save(rootCluster);
        TreeCluster readCluster = stFile.Cluster.load(matrix.getRowCount());
        TreeScalar scalar = new TreeScalar();
        scalar.extract(matrix);
        stFile.Scalar.save(scalar);
        float value = stFile.Scalar.getById(0);
        float[] values = stFile.Scalar.getAllValues();
        TreeLabel labels = new TreeLabel();
        labels.extract(matrix);
        stFile.Label.save(labels);
        String label = stFile.Label.getById(0);
        List<String> allLabels = stFile.Label.getLabels();
        System.out.println("END!");
    }

    private static void testDocumentPointsMatrix() throws IOException {
        System.out.println("Reading points matrix...");
        AbstractMatrix matrix = MatrixFactory.getInstance("/home/renato/AP_BBC_CNN_Reuters_nosource_nodate_novo.data");
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.COSINE_BASED);
        System.out.println("Clustering points matrix");
        TreeMultilevelClustering clus = new TreeMultilevelClustering();
        Clustering technique = TreeMultilevelClustering.getClusteringTechnique(0, "10", diss, matrix);
        TreeCluster rootCluster = clus.clusterize(matrix, technique, diss, 50, false, 10);
        System.out.println("End clustering");
        String filename = "/home/renato/AP_BBC_CNN_Reuters_nosource_nodate_novo.stree";
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
        SupertreeFile stFile = new SupertreeFile(filename);
        stFile.Cluster.Metadata.clusParams = "K = 10, Max Cluster Size = 50";
        stFile.Cluster.Metadata.clusTechnique = "K-Means";
        stFile.Cluster.Metadata.dimensionality = matrix.getDimensions();
        stFile.Cluster.Metadata.dissName = "Cosine based";
        stFile.Cluster.Metadata.inputMatrixName = filename;
        stFile.Cluster.Metadata.inputMatrixSize = matrix.getRowCount();
        stFile.Cluster.save(rootCluster);
        stFile.Cluster.loadHeader();
        TreeCluster readCluster = stFile.Cluster.load(stFile.Cluster.Metadata.inputMatrixSize);
        TreeScalar scalar = new TreeScalar();
        scalar.extract(matrix);
        stFile.Scalar.save(scalar);
        float value = stFile.Scalar.getById(0);
        float[] values = stFile.Scalar.getAllValues();
        TreeLabel labels = new TreeLabel();
        labels.extract(matrix);
        stFile.Label.save(labels);
        String label = stFile.Label.getById(0);
        List<String> allLabels = stFile.Label.getLabels();
        TreeTopicExtractor topicExtractor = new TreeTopicExtractor(30, matrix);
        List<TreeTopic> topics = topicExtractor.extractFromHierarchy(rootCluster);
        stFile.Topic.save(topics);
        topics.clear();
        topics = stFile.Topic.getTopics();
        TreeTopic topic = stFile.Topic.getById(stFile.Cluster.Metadata.inputMatrixSize);
        System.out.println("END!");
    }

    public static void main(String[] args) throws IOException {
        SupertreeFile stFile = new SupertreeFile("/home/renato/stackoverflow-1kpm.data.stree");
        TreeCluster rootCluster = stFile.Cluster.loadAll();
        String label = stFile.Label.getById(0);
    }

    public class Topic {
        private final TreeTopicFile topicFile;

        public Topic(String fileName) {
            this.topicFile = new TreeTopicFile(fileName);
        }

        public boolean hasTopics() {
            try {
                if (SupertreeFile.this.entries == null) {
                    SupertreeFile.this.loadEntries();
                }
                return SupertreeFile.this.entries.containsKey(4);
            }
            catch (IOException ex) {
                Logger.getLogger(SupertreeFile.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }

        public void save(List<TreeTopic> topics) throws IOException {
            SupertreeFile.this.loadEntries();
            if (SupertreeFile.this.entries.containsKey(4)) {
                return;
            }
            FileEntry topicEntry = SupertreeFile.this.createNewEntry(4);
            this.topicFile.start = topicEntry.start;
            this.topicFile.save(topics);
            topicEntry.end = this.topicFile.end;
            SupertreeFile.this.entries.put(4, topicEntry);
            SupertreeFile.this.updateEntries();
        }

        public TreeTopic getById(int id) throws IOException {
            SupertreeFile.this.loadEntries();
            if (!SupertreeFile.this.entries.containsKey(4)) {
                return null;
            }
            FileEntry topicEntry = (FileEntry)SupertreeFile.this.entries.get(4);
            this.topicFile.start = topicEntry.start;
            this.topicFile.end = topicEntry.end;
            TreeTopic topic = this.topicFile.load(id);
            return topic;
        }

        public List<TreeTopic> getTopics() throws IOException {
            SupertreeFile.this.loadEntries();
            if (!SupertreeFile.this.entries.containsKey(4)) {
                return null;
            }
            FileEntry topicEntry = (FileEntry)SupertreeFile.this.entries.get(4);
            this.topicFile.start = topicEntry.start;
            this.topicFile.end = topicEntry.end;
            List<TreeTopic> topics = this.topicFile.loadAll();
            return topics;
        }
    }

    public class Label {
        public boolean loadAll = true;
        private List<String> labels = null;

        public boolean hasLabels() {
            try {
                if (SupertreeFile.this.entries == null) {
                    SupertreeFile.this.loadEntries();
                }
                return SupertreeFile.this.entries.containsKey(3);
            }
            catch (IOException ex) {
                Logger.getLogger(SupertreeFile.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }

        public void save(TreeLabel treeLabels) throws IOException {
            SupertreeFile.this.loadEntries();
            if (SupertreeFile.this.entries.containsKey(3)) {
                return;
            }
            FileEntry labelEntry = SupertreeFile.this.createNewEntry(3);
            treeLabels.setStart(labelEntry.start);
            treeLabels.save(SupertreeFile.this.filename);
            labelEntry.end = treeLabels.getEnd();
            SupertreeFile.this.entries.put(3, labelEntry);
            SupertreeFile.this.updateEntries();
        }

        public String getById(int id) throws IOException {
            if (this.labels != null) {
                if (id < this.labels.size()) {
                    return this.labels.get(id);
                }
                return null;
            }
            if (this.loadAll) {
                this.labels = this.getLabels();
                if (this.labels != null) {
                    if (id < this.labels.size()) {
                        return this.labels.get(id);
                    }
                    return null;
                }
                return null;
            }
            SupertreeFile.this.loadEntries();
            if (!SupertreeFile.this.entries.containsKey(3)) {
                return null;
            }
            FileEntry labelEntry = (FileEntry)SupertreeFile.this.entries.get(3);
            TreeLabel treeLabel = new TreeLabel();
            treeLabel.setStart(labelEntry.start);
            treeLabel.setEnd(labelEntry.end);
            String label = treeLabel.read(id, SupertreeFile.this.filename);
            return label;
        }

        public List<String> getLabels() throws IOException {
            if (SupertreeFile.this.entries == null) {
                SupertreeFile.this.loadEntries();
            }
            if (!SupertreeFile.this.entries.containsKey(3)) {
                return null;
            }
            FileEntry labelEntry = (FileEntry)SupertreeFile.this.entries.get(3);
            TreeLabel treeLabel = new TreeLabel();
            treeLabel.setStart(labelEntry.start);
            treeLabel.setEnd(labelEntry.end);
            treeLabel.load(SupertreeFile.this.filename);
            List<String> values = treeLabel.getLabels();
            return values;
        }
    }

    public class Scalar {
        public final boolean loadAll = true;
        private Float min = null;
        private Float max = null;
        private float[] values = null;

        public boolean hasScalars() {
            try {
                if (SupertreeFile.this.entries == null) {
                    SupertreeFile.this.loadEntries();
                }
                return SupertreeFile.this.entries.containsKey(2);
            }
            catch (IOException ex) {
                Logger.getLogger(SupertreeFile.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }

        public float getMin() throws IOException {
            if (this.min != null) {
                return this.min.floatValue();
            }
            SupertreeFile.this.loadEntries();
            if (!SupertreeFile.this.entries.containsKey(2)) {
                return Float.NaN;
            }
            FileEntry scalarEntry = (FileEntry)SupertreeFile.this.entries.get(2);
            TreeScalar scalar = new TreeScalar();
            scalar.setStart(scalarEntry.start);
            scalar.setEnd(scalarEntry.end);
            float value = scalar.readMin(SupertreeFile.this.filename);
            this.min = Float.valueOf(value);
            return value;
        }

        public float getMax() throws IOException {
            if (this.max != null) {
                return this.max.floatValue();
            }
            SupertreeFile.this.loadEntries();
            if (!SupertreeFile.this.entries.containsKey(2)) {
                return Float.NaN;
            }
            FileEntry scalarEntry = (FileEntry)SupertreeFile.this.entries.get(2);
            TreeScalar scalar = new TreeScalar();
            scalar.setStart(scalarEntry.start);
            scalar.setEnd(scalarEntry.end);
            float value = scalar.readMax(SupertreeFile.this.filename);
            this.max = Float.valueOf(value);
            return value;
        }

        public void save(TreeScalar treeScalar) throws IOException {
            SupertreeFile.this.loadEntries();
            if (SupertreeFile.this.entries.containsKey(2)) {
                return;
            }
            FileEntry scalarEntry = SupertreeFile.this.createNewEntry(2);
            treeScalar.setStart(scalarEntry.start);
            treeScalar.save(SupertreeFile.this.filename);
            scalarEntry.end = treeScalar.getEnd();
            SupertreeFile.this.entries.put(2, scalarEntry);
            SupertreeFile.this.updateEntries();
        }

        public float getById(int id) throws IOException {
            if (this.values != null) {
                if (id < this.values.length) {
                    return this.values[id];
                }
                return 0.0f;
            }
            this.getAllValues();
            if (this.values != null && id < this.values.length) {
                return this.values[id];
            }
            return 0.0f;
        }

        public float[] getAllValues() throws IOException {
            if (SupertreeFile.this.entries == null) {
                SupertreeFile.this.loadEntries();
            }
            if (!SupertreeFile.this.entries.containsKey(2)) {
                return null;
            }
            FileEntry scalarEntry = (FileEntry)SupertreeFile.this.entries.get(2);
            TreeScalar treeScalar = new TreeScalar();
            treeScalar.setStart(scalarEntry.start);
            treeScalar.setEnd(scalarEntry.end);
            treeScalar.load(SupertreeFile.this.filename);
            List<Float> loadedValues = treeScalar.getValues();
            this.values = new float[loadedValues.size()];
            for (int i = 0; i < loadedValues.size(); ++i) {
                this.values[i] = loadedValues.get(i).floatValue();
            }
            return this.values;
        }
    }

    public class Cluster {
        public Metadata Metadata = new Metadata();

        public void loadHeader() throws IOException {
            SupertreeFile.this.loadEntries();
            if (!SupertreeFile.this.entries.containsKey(1)) {
                return;
            }
            FileEntry clusEntry = (FileEntry)SupertreeFile.this.entries.get(1);
            TreeClusterFile clusterFile = new TreeClusterFile(SupertreeFile.this.filename);
            clusterFile.setStart(clusEntry.start);
            clusterFile.setEnd(clusEntry.end);
            clusterFile.readHeader();
            this.Metadata.inputMatrixName = clusterFile.getInputMatrixName();
            this.Metadata.inputMatrixSize = clusterFile.getElementCount();
            this.Metadata.dimensionality = clusterFile.getDimensionality();
            this.Metadata.dissName = clusterFile.getDissName();
            this.Metadata.clusTechnique = clusterFile.getClusteringTechnique();
            this.Metadata.clusParams = clusterFile.getClusteringParams();
        }

        public void save(TreeCluster rootCluster) throws FileNotFoundException, IOException {
            SupertreeFile.this.loadEntries();
            if (SupertreeFile.this.entries.containsKey(1)) {
                return;
            }
            FileEntry clusEntry = SupertreeFile.this.createNewEntry(1);
            TreeClusterFile clusterFile = new TreeClusterFile(SupertreeFile.this.filename);
            clusterFile.setClusteringParams(this.Metadata.clusParams);
            clusterFile.setClusteringTechnique(this.Metadata.clusTechnique);
            clusterFile.setDimensionality(this.Metadata.dimensionality);
            clusterFile.setDissName(this.Metadata.dissName);
            clusterFile.setElementCount(this.Metadata.inputMatrixSize);
            clusterFile.setInputMatrixName(this.Metadata.inputMatrixName);
            clusterFile.setStart(clusEntry.start);
            clusterFile.write(rootCluster);
            clusEntry.end = clusterFile.getEnd();
            SupertreeFile.this.entries.put(1, clusEntry);
            SupertreeFile.this.updateEntries();
        }

        public TreeCluster load(int id) throws IOException {
            if (SupertreeFile.this.entries == null) {
                SupertreeFile.this.loadEntries();
            }
            if (!SupertreeFile.this.entries.containsKey(1)) {
                return null;
            }
            FileEntry clusEntry = (FileEntry)SupertreeFile.this.entries.get(1);
            TreeClusterFile clusterFile = new TreeClusterFile(SupertreeFile.this.filename);
            clusterFile.setStart(clusEntry.start);
            clusterFile.setEnd(clusEntry.end);
            TreeCluster treeCluster = clusterFile.read(id);
            return treeCluster;
        }

        public TreeCluster loadAll() throws IOException {
            SupertreeFile.this.loadEntries();
            if (!SupertreeFile.this.entries.containsKey(1)) {
                return null;
            }
            FileEntry clusEntry = (FileEntry)SupertreeFile.this.entries.get(1);
            TreeClusterFile clusterFile = new TreeClusterFile(SupertreeFile.this.filename);
            clusterFile.setStart(clusEntry.start);
            clusterFile.setEnd(clusEntry.end);
            TreeCluster rootCluster = clusterFile.readAll();
            return rootCluster;
        }

        public class Metadata {
            public String inputMatrixName = "";
            public int inputMatrixSize;
            public int dimensionality;
            public String dissName = "";
            public String clusTechnique = "";
            public String clusParams = "";
        }
    }
}

