/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.file.component;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import simpletree.datamining.clustering.Clustering;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.cluster.TreeMultilevelClustering;
import simpletree.io.file.SupertreeFile;
import simpletree.io.file.component.BinaryWriterParamView;
import simpletree.io.label.TreeLabel;
import simpletree.io.scalar.TreeScalar;
import simpletree.io.topic.TreeTopic;
import simpletree.io.topic.TreeTopicExtractor;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Disk", name="Binary SuperTree Writer", description="Write a Super Tree to a binary file.")
public class BinaryWriterComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename;
    private String clusteringParams = "10";
    private int clusteringTechnique = 0;
    private int numMedoids = 10;
    private boolean useClassesAsClusters = false;
    private int maxClusterSize = 50;
    private DissimilarityFactory.DissimilarityType dissType;
    private transient BinaryWriterParamView paramview;
    private transient AbstractMatrix matrix;

    private boolean checkErrors() {
        if (this.matrix == null) {
            System.out.println("An input matrix is required!");
            return false;
        }
        if (this.filename == null || this.filename.isEmpty()) {
            System.out.println("It is required to select a path to store the output binary file");
            return false;
        }
        return true;
    }

    public void execute() throws IOException {
        ArrayList<String> labelList;
        if (!this.checkErrors()) {
            return;
        }
        TreeMultilevelClustering clus = new TreeMultilevelClustering();
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.dissType);
        Clustering technique = TreeMultilevelClustering.getClusteringTechnique(this.clusteringTechnique, this.clusteringParams, diss, this.matrix);
        TreeCluster rootCluster = clus.clusterize(this.matrix, technique, diss, this.maxClusterSize, this.useClassesAsClusters, this.numMedoids);
        File file = new File(this.filename);
        if (file.exists()) {
            file.delete();
        }
        SupertreeFile stFile = new SupertreeFile(this.filename);
        stFile.Cluster.Metadata.clusParams = this.clusteringParams;
        stFile.Cluster.Metadata.dimensionality = this.matrix.getDimensions();
        stFile.Cluster.Metadata.dissName = diss.toString();
        stFile.Cluster.Metadata.inputMatrixName = "";
        stFile.Cluster.Metadata.inputMatrixSize = this.matrix.getRowCount();
        stFile.Cluster.Metadata.clusTechnique = "K-Means";
        stFile.Cluster.save(rootCluster);
        TreeScalar scalar = new TreeScalar();
        scalar.extract(this.matrix);
        if (!scalar.getValues().isEmpty()) {
            stFile.Scalar.save(scalar);
        }
        TreeLabel labels = new TreeLabel();
        labels.extract(this.matrix);
        if (!labels.getLabels().isEmpty()) {
            stFile.Label.save(labels);
        }
        if (!(labelList = this.matrix.getLabels()).isEmpty() && labelList.get(0).endsWith(".txt")) {
            ArrayList<TreeTopic> topics = new ArrayList<TreeTopic>();
            TreeTopicExtractor topicExtractor = new TreeTopicExtractor(30, this.matrix);
            for (TreeCluster subCluster : rootCluster.getSubClusterList()) {
                topics.addAll(topicExtractor.extractFromHierarchy(subCluster));
            }
            stFile.Topic.save(topics);
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new BinaryWriterParamView(this);
        }
        return this.paramview;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void reset() {
        this.matrix = null;
    }

    public String getClusteringParams() {
        return this.clusteringParams;
    }

    public void setClusteringParams(String clusteringParams) {
        this.clusteringParams = clusteringParams;
    }

    public int getClusteringTechnique() {
        return this.clusteringTechnique;
    }

    public void setClusteringTechnique(int clusteringTechnique) {
        this.clusteringTechnique = clusteringTechnique;
    }

    public int getNumMedoids() {
        return this.numMedoids;
    }

    public void setNumMedoids(int numMedoids) {
        this.numMedoids = numMedoids;
    }

    public boolean isUseClassesAsClusters() {
        return this.useClassesAsClusters;
    }

    public void setUseClassesAsClusters(boolean useClassesAsClusters) {
        this.useClassesAsClusters = useClassesAsClusters;
    }

    public int getMaxClusterSize() {
        return this.maxClusterSize;
    }

    public void setMaxClusterSize(int maxClusterSize) {
        this.maxClusterSize = maxClusterSize;
    }

    public DissimilarityFactory.DissimilarityType getDissType() {
        return this.dissType;
    }

    public void setDissType(DissimilarityFactory.DissimilarityType dissType) {
        this.dissType = dissType;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 7) {
            System.out.println("Usage: java -jar program.jar [inputMatrix.data] [dissimilarity = e | c] [classes as clusters = 0 | 1] [number of clusters] [max clus size] [num of medoids] [output.stree]");
            System.exit(0);
        }
        AbstractMatrix mat = MatrixFactory.getInstance(args[0]);
        BinaryWriterComp comp = new BinaryWriterComp();
        comp.input(mat);
        if (args[1].toLowerCase().equals("c")) {
            comp.setDissType(DissimilarityFactory.DissimilarityType.COSINE_BASED);
        } else {
            comp.setDissType(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        }
        comp.setClusteringTechnique(0);
        if (args[2].equals("0")) {
            comp.setUseClassesAsClusters(false);
        } else {
            comp.setUseClassesAsClusters(true);
        }
        comp.setClusteringParams(args[3]);
        comp.setMaxClusterSize(Integer.valueOf(args[4]));
        comp.setNumMedoids(Integer.valueOf(args[5]));
        comp.setFilename(args[6]);
        comp.execute();
    }
}

