/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.file.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.io.file.component.BinaryWriterComp;
import simpletree.io.util.StreeFilter;
import simpletree.matrix.writer.MatrixWriterParamView;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import vispipelinebasics.interfaces.AbstractParametersView;

public class BinaryWriterParamView
extends AbstractParametersView {
    protected BinaryWriterComp comp;
    private ButtonGroup buttonGroup1;
    private JComboBox centroidSelectionTechniqueComboBox;
    private JLabel centroidSelectionTechniqueLabel;
    private JPanel clusteringPanel;
    private JComboBox clusteringTechniqueComboBox;
    private JPanel clusteringTypePanel;
    private JComboBox dissimilarityComboBox;
    protected JPanel dissimilarityPanel;
    private JPanel filenamePanel;
    private JTextField filenameTextField;
    private JLabel hierarchicalLabel;
    private JPanel hierarchicalPanel;
    private JComboBox hierarchicalTypeComboBox;
    private JPanel isodataPanel;
    private JLabel jLabel1;
    private JLabel kLabel;
    private JTextField kTextField;
    private JLabel maxClusterSizeLabel;
    private JTextField maxClusterSizeTextField;
    private JLabel maxItersLabel;
    private JTextField maxItersTextField;
    private JLabel maxMergeNumsThresLabel;
    private JTextField maxMergeNumsThresTextField;
    private JLabel minDistanceThresLabel;
    private JTextField minDistanceThresTextField;
    private JLabel minNumThresLabel;
    private JTextField minNumThresTextField;
    private JPanel multiscalePanel;
    private JLabel nrMedoidsLabel;
    private JTextField nrMedoidsText;
    private JLabel nrMicroclustersLabel;
    private JTextField nrMicroclustersTextField;
    private JLabel nrclustersLabel;
    private JTextField nrclustersTextField;
    private JButton searchFilenameButton;
    private JTextField stdDeviationThresTextField;
    private JLabel std_deviationThresLabel;
    private JCheckBox useClassesAsClustersCheckBox;

    public BinaryWriterParamView(BinaryWriterComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType type : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(type);
        }
        this.nrMicroclustersLabel.setVisible(false);
        this.nrMicroclustersTextField.setVisible(false);
        this.centroidSelectionTechniqueLabel.setVisible(false);
        this.centroidSelectionTechniqueComboBox.setVisible(false);
        this.reset();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.filenamePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.filenameTextField = new JTextField();
        this.searchFilenameButton = new JButton();
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.clusteringPanel = new JPanel();
        this.clusteringTypePanel = new JPanel();
        this.clusteringTechniqueComboBox = new JComboBox();
        this.nrclustersLabel = new JLabel();
        this.nrclustersTextField = new JTextField();
        this.nrMicroclustersLabel = new JLabel();
        this.nrMicroclustersTextField = new JTextField();
        this.centroidSelectionTechniqueLabel = new JLabel();
        this.centroidSelectionTechniqueComboBox = new JComboBox();
        this.isodataPanel = new JPanel();
        this.kLabel = new JLabel();
        this.minNumThresLabel = new JLabel();
        this.std_deviationThresLabel = new JLabel();
        this.minDistanceThresLabel = new JLabel();
        this.maxMergeNumsThresLabel = new JLabel();
        this.maxItersLabel = new JLabel();
        this.kTextField = new JTextField();
        this.minNumThresTextField = new JTextField();
        this.stdDeviationThresTextField = new JTextField();
        this.minDistanceThresTextField = new JTextField();
        this.maxMergeNumsThresTextField = new JTextField();
        this.maxItersTextField = new JTextField();
        this.hierarchicalPanel = new JPanel();
        this.hierarchicalLabel = new JLabel();
        this.hierarchicalTypeComboBox = new JComboBox();
        this.multiscalePanel = new JPanel();
        this.maxClusterSizeLabel = new JLabel();
        this.maxClusterSizeTextField = new JTextField();
        this.nrMedoidsLabel = new JLabel();
        this.nrMedoidsText = new JTextField();
        this.useClassesAsClustersCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Neighbor Joining Connection Parameters"));
        this.setLayout(new GridBagLayout());
        this.filenamePanel.setLayout(new GridBagLayout());
        this.jLabel1.setText("File name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.filenamePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.filenameTextField.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.filenamePanel.add((Component)this.filenameTextField, gridBagConstraints);
        this.searchFilenameButton.setText("Search...");
        this.searchFilenameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryWriterParamView.this.searchFilenameButtonActionPerformed(evt);
            }
        });
        this.filenamePanel.add((Component)this.searchFilenameButton, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add(this.filenamePanel, gridBagConstraints);
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.clusteringPanel.setBorder(BorderFactory.createTitledBorder("Clustering Parameters"));
        this.clusteringPanel.setLayout(new GridBagLayout());
        this.clusteringTypePanel.setBorder(BorderFactory.createTitledBorder("Clustering Type"));
        this.clusteringTypePanel.setLayout(new GridBagLayout());
        this.clusteringTechniqueComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"K-means", "Bissecting K-means", "K-medoids", "Hierarchical", "X-means", "Clustream", "DBScan", "IsoData"}));
        this.clusteringTechniqueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BinaryWriterParamView.this.clusteringTechniqueComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.clusteringTypePanel.add((Component)this.clusteringTechniqueComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.clusteringPanel.add((Component)this.clusteringTypePanel, gridBagConstraints);
        this.nrclustersLabel.setText("Number Clusters : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clusteringPanel.add((Component)this.nrclustersLabel, gridBagConstraints);
        this.nrclustersTextField.setColumns(5);
        this.nrclustersTextField.setText("5");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clusteringPanel.add((Component)this.nrclustersTextField, gridBagConstraints);
        this.nrMicroclustersLabel.setText("Number of MicroClusters : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clusteringPanel.add((Component)this.nrMicroclustersLabel, gridBagConstraints);
        this.nrMicroclustersTextField.setColumns(5);
        this.nrMicroclustersTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clusteringPanel.add((Component)this.nrMicroclustersTextField, gridBagConstraints);
        this.centroidSelectionTechniqueLabel.setText("Centers Selection Technique : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clusteringPanel.add((Component)this.centroidSelectionTechniqueLabel, gridBagConstraints);
        this.centroidSelectionTechniqueComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Kmeans++", "Equally Spaced Centers", "Sequential Centers", "Clustream Centers", "Randomly Centers"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.clusteringPanel.add((Component)this.centroidSelectionTechniqueComboBox, gridBagConstraints);
        this.isodataPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.isodataPanel.setLayout(new GridBagLayout());
        this.kLabel.setText("Minimum Number of Clusters :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.kLabel, gridBagConstraints);
        this.minNumThresLabel.setText("MinNumThreshold : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.minNumThresLabel, gridBagConstraints);
        this.std_deviationThresLabel.setText("Standard Deviation Threshold : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.std_deviationThresLabel, gridBagConstraints);
        this.minDistanceThresLabel.setText("Minimum Distance Threshold :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.minDistanceThresLabel, gridBagConstraints);
        this.maxMergeNumsThresLabel.setText("maxMergeNumsThres : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.maxMergeNumsThresLabel, gridBagConstraints);
        this.maxItersLabel.setText("Number Iterations : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.maxItersLabel, gridBagConstraints);
        this.kTextField.setText("4");
        this.kTextField.setPreferredSize(new Dimension(46, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.kTextField, gridBagConstraints);
        this.minNumThresTextField.setText("2");
        this.minNumThresTextField.setPreferredSize(new Dimension(46, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.minNumThresTextField, gridBagConstraints);
        this.stdDeviationThresTextField.setText("0.0001");
        this.stdDeviationThresTextField.setPreferredSize(new Dimension(46, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.stdDeviationThresTextField, gridBagConstraints);
        this.minDistanceThresTextField.setText("0.0004");
        this.minDistanceThresTextField.setPreferredSize(new Dimension(46, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.minDistanceThresTextField, gridBagConstraints);
        this.maxMergeNumsThresTextField.setText("1");
        this.maxMergeNumsThresTextField.setPreferredSize(new Dimension(46, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.maxMergeNumsThresTextField, gridBagConstraints);
        this.maxItersTextField.setText("40");
        this.maxItersTextField.setPreferredSize(new Dimension(46, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.isodataPanel.add((Component)this.maxItersTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.clusteringPanel.add((Component)this.isodataPanel, gridBagConstraints);
        this.hierarchicalLabel.setText("Hierarchical Type : ");
        this.hierarchicalPanel.add(this.hierarchicalLabel);
        this.hierarchicalTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Single Link", "Complete Link", "Average Link"}));
        this.hierarchicalPanel.add(this.hierarchicalTypeComboBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.clusteringPanel.add((Component)this.hierarchicalPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add(this.clusteringPanel, gridBagConstraints);
        this.multiscalePanel.setBorder(BorderFactory.createTitledBorder(""));
        this.multiscalePanel.setLayout(new GridBagLayout());
        this.maxClusterSizeLabel.setText("Max Cluster Size : ");
        this.multiscalePanel.add((Component)this.maxClusterSizeLabel, new GridBagConstraints());
        this.maxClusterSizeTextField.setColumns(5);
        this.maxClusterSizeTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.multiscalePanel.add((Component)this.maxClusterSizeTextField, gridBagConstraints);
        this.nrMedoidsLabel.setText("Number Medoids:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.multiscalePanel.add((Component)this.nrMedoidsLabel, gridBagConstraints);
        this.nrMedoidsText.setText("10");
        this.nrMedoidsText.setToolTipText("Number of medoids stored for each cluster");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.multiscalePanel.add((Component)this.nrMedoidsText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add(this.multiscalePanel, gridBagConstraints);
        this.useClassesAsClustersCheckBox.setText("Use Classes as Initial Clusters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add(this.useClassesAsClustersCheckBox, gridBagConstraints);
    }

    private void clusteringTechniqueComboBoxActionPerformed(ActionEvent evt) {
        switch (this.clusteringTechniqueComboBox.getSelectedIndex()) {
            case 0: {
                this.nrclustersTextField.setEnabled(true);
                this.nrMicroclustersLabel.setVisible(false);
                this.nrMicroclustersTextField.setVisible(false);
                this.centroidSelectionTechniqueLabel.setVisible(false);
                this.centroidSelectionTechniqueComboBox.setVisible(false);
                this.hierarchicalPanel.setVisible(false);
                this.isodataPanel.setVisible(false);
                break;
            }
            case 1: {
                this.nrclustersTextField.setEnabled(true);
                this.nrMicroclustersLabel.setVisible(false);
                this.nrMicroclustersTextField.setVisible(false);
                this.centroidSelectionTechniqueLabel.setVisible(false);
                this.centroidSelectionTechniqueComboBox.setVisible(false);
                this.hierarchicalPanel.setVisible(false);
                this.isodataPanel.setVisible(false);
                break;
            }
            case 2: {
                this.nrclustersTextField.setEnabled(true);
                this.nrMicroclustersLabel.setVisible(false);
                this.nrMicroclustersTextField.setVisible(false);
                this.centroidSelectionTechniqueLabel.setVisible(false);
                this.centroidSelectionTechniqueComboBox.setVisible(false);
                this.hierarchicalPanel.setVisible(false);
                this.isodataPanel.setVisible(false);
                break;
            }
            case 3: {
                this.nrclustersTextField.setEnabled(true);
                this.nrMicroclustersLabel.setVisible(false);
                this.nrMicroclustersTextField.setVisible(false);
                this.centroidSelectionTechniqueLabel.setVisible(false);
                this.centroidSelectionTechniqueComboBox.setVisible(false);
                this.isodataPanel.setVisible(false);
                this.hierarchicalPanel.setVisible(true);
                break;
            }
            case 4: {
                this.nrclustersTextField.setEnabled(false);
                this.nrMicroclustersLabel.setVisible(false);
                this.nrMicroclustersTextField.setVisible(false);
                this.centroidSelectionTechniqueLabel.setVisible(false);
                this.centroidSelectionTechniqueComboBox.setVisible(false);
                this.hierarchicalPanel.setVisible(false);
                this.isodataPanel.setVisible(false);
                break;
            }
            case 5: {
                this.nrclustersTextField.setEnabled(true);
                this.nrMicroclustersLabel.setVisible(true);
                this.nrMicroclustersTextField.setVisible(true);
                this.centroidSelectionTechniqueLabel.setVisible(true);
                this.centroidSelectionTechniqueComboBox.setVisible(true);
                this.hierarchicalPanel.setVisible(false);
                this.isodataPanel.setVisible(false);
                break;
            }
            case 6: {
                this.nrclustersTextField.setEnabled(false);
                this.nrMicroclustersLabel.setVisible(false);
                this.nrMicroclustersTextField.setVisible(false);
                this.centroidSelectionTechniqueLabel.setVisible(false);
                this.centroidSelectionTechniqueComboBox.setVisible(false);
                this.hierarchicalPanel.setVisible(false);
                this.isodataPanel.setVisible(false);
                break;
            }
            case 7: {
                this.nrclustersTextField.setEnabled(false);
                this.nrMicroclustersLabel.setVisible(false);
                this.nrMicroclustersTextField.setVisible(false);
                this.centroidSelectionTechniqueLabel.setVisible(false);
                this.centroidSelectionTechniqueComboBox.setVisible(false);
                this.hierarchicalPanel.setVisible(false);
                this.isodataPanel.setVisible(true);
            }
        }
    }

    private void searchFilenameButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            int result = SaveDialog.showSaveDialog(spm, new StreeFilter(), (Component)((Object)this), "data.stree");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                this.filenameTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MatrixWriterParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissType());
        this.clusteringTechniqueComboBox.setSelectedIndex(this.comp.getClusteringTechnique());
        if (this.comp.getClusteringTechnique() == 7) {
            this.isodataPanel.setVisible(true);
            if (this.comp.getClusteringParams() != null && !this.comp.getClusteringParams().isEmpty()) {
                String[] params = this.comp.getClusteringParams().split(";");
                this.kTextField.setText(params[0]);
                this.minNumThresTextField.setText(params[1]);
                this.stdDeviationThresTextField.setText(params[2]);
                this.minDistanceThresTextField.setText(params[3]);
                this.maxMergeNumsThresTextField.setText(params[4]);
                this.maxItersTextField.setText(params[5]);
            }
        } else if (this.comp.getClusteringTechnique() == 5) {
            this.nrMicroclustersTextField.setText(this.comp.getClusteringParams());
        } else if (this.comp.getClusteringTechnique() >= 0 && this.comp.getClusteringTechnique() <= 3) {
            if (this.comp.getClusteringTechnique() == 3) {
                String[] params = this.comp.getClusteringParams().split(";");
                this.nrclustersTextField.setText(params[0]);
                this.hierarchicalTypeComboBox.setSelectedItem(params[1]);
            } else {
                this.nrclustersTextField.setText(this.comp.getClusteringParams());
            }
        }
        this.useClassesAsClustersCheckBox.setSelected(this.comp.isUseClassesAsClusters());
        this.nrclustersTextField.setText(this.comp.getClusteringParams());
        this.maxClusterSizeTextField.setText(Integer.toString(this.comp.getMaxClusterSize()));
        this.nrMedoidsText.setText(Integer.toString(this.comp.getNumMedoids()));
        this.filenameTextField.setText(this.comp.getFilename());
    }

    public void finished() throws IOException {
        this.comp.setDissType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
        this.comp.setClusteringTechnique(this.clusteringTechniqueComboBox.getSelectedIndex());
        if (this.comp.getClusteringTechnique() == 5) {
            this.comp.setClusteringParams(this.nrMicroclustersTextField.getText());
        } else if (this.comp.getClusteringTechnique() == 7) {
            String isodataParameters = this.kTextField.getText() + ";" + this.minNumThresTextField.getText() + ";" + this.stdDeviationThresTextField.getText() + ";" + this.minDistanceThresTextField.getText() + ";" + this.maxMergeNumsThresTextField.getText() + ";" + this.maxItersTextField.getText();
            this.comp.setClusteringParams(isodataParameters);
        } else if (this.comp.getClusteringTechnique() >= 0 && this.comp.getClusteringTechnique() <= 3) {
            String hparameters = this.nrclustersTextField.getText();
            if (this.comp.getClusteringTechnique() == 3) {
                hparameters = hparameters + ";" + (String)this.hierarchicalTypeComboBox.getSelectedItem();
            }
            this.comp.setClusteringParams(hparameters);
        }
        this.comp.setUseClassesAsClusters(this.useClassesAsClustersCheckBox.isSelected());
        this.comp.setClusteringParams(this.nrclustersTextField.getText());
        this.comp.setMaxClusterSize(Integer.parseInt(this.maxClusterSizeTextField.getText()));
        this.comp.setNumMedoids(Integer.valueOf(this.nrMedoidsText.getText()));
        this.comp.setFilename(this.filenameTextField.getText());
    }
}

