/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.topic;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.io.topic.TreeTopic;
import simpletree.io.util.Pair;

public class TreeTopicFile {
    public long start = 0L;
    public long end = 0L;
    private String filename = "";
    private Map<Integer, Long> topicAddressMap = new HashMap<Integer, Long>();
    private Map<Integer, TreeTopic> topicMap = new HashMap<Integer, TreeTopic>();
    private String technique = "";
    private String parameters = "";
    private int topicsCount;

    public TreeTopicFile(String filename) {
        this.filename = filename;
    }

    private void writeHeader(RandomAccessFile out) throws FileNotFoundException, IOException {
        out.writeInt(this.topicsCount);
        out.writeInt(this.getTechnique().getBytes().length);
        out.write(this.getTechnique().getBytes());
        out.writeInt(this.getParameters().getBytes().length);
        out.write(this.getParameters().getBytes());
    }

    private void readHeader(RandomAccessFile in) throws FileNotFoundException, IOException {
        this.topicsCount = in.readInt();
        int techniqueLength = in.readInt();
        byte[] techNameBytes = new byte[techniqueLength];
        in.read(techNameBytes);
        this.technique = new String(techNameBytes);
        int parametersLength = in.readInt();
        byte[] parametersBytes = new byte[parametersLength];
        in.read(parametersBytes);
        this.parameters = new String(parametersBytes);
    }

    private void readHeader(ByteBuffer in) {
        this.topicsCount = in.getInt();
        int techniqueLength = in.getInt();
        byte[] techNameBytes = new byte[techniqueLength];
        in.get(techNameBytes);
        this.technique = new String(techNameBytes);
        int parametersLength = in.getInt();
        byte[] parametersBytes = new byte[parametersLength];
        in.get(parametersBytes);
        this.parameters = new String(parametersBytes);
    }

    public void save(List<TreeTopic> topicList) throws FileNotFoundException, IOException {
        this.topicsCount = topicList.size();
        try (RandomAccessFile out = new RandomAccessFile(this.filename, "rw");){
            out.seek(this.start);
            this.writeHeader(out);
            this.topicAddressMap = new HashMap<Integer, Long>();
            for (TreeTopic topic : topicList) {
                this.topicAddressMap.put(topic.id, out.getFilePointer());
                out.writeInt(topic.id);
                out.writeInt(topic.words.size());
                for (Pair<String, Float> weightedWord : topic.words) {
                    out.writeInt(((String)weightedWord.first).getBytes().length);
                    out.write(((String)weightedWord.first).getBytes());
                    out.writeFloat(((Float)weightedWord.second).floatValue());
                }
            }
            Long indicesOffset = out.getFilePointer();
            for (Map.Entry<Integer, Long> entry : this.topicAddressMap.entrySet()) {
                out.writeInt(entry.getKey());
                out.writeLong(entry.getValue());
            }
            out.writeLong(indicesOffset);
            this.end = out.getFilePointer();
        }
    }

    private TreeTopic readTopic(RandomAccessFile in) throws IOException {
        TreeTopic newTopic = new TreeTopic();
        newTopic.id = in.readInt();
        int topicSize = in.readInt();
        ArrayList<Pair<String, Float>> words = new ArrayList<Pair<String, Float>>();
        for (int j = 0; j < topicSize; ++j) {
            int wordSize = in.readInt();
            byte[] wordBytes = new byte[wordSize];
            in.read(wordBytes);
            String word = new String(wordBytes);
            float wordWeight = in.readFloat();
            words.add(new Pair<String, Float>(word, Float.valueOf(wordWeight)));
        }
        newTopic.words = words;
        return newTopic;
    }

    private TreeTopic readTopic(ByteBuffer in) {
        TreeTopic newTopic = new TreeTopic();
        newTopic.id = in.getInt();
        int topicSize = in.getInt();
        ArrayList<Pair<String, Float>> words = new ArrayList<Pair<String, Float>>();
        for (int j = 0; j < topicSize; ++j) {
            int wordSize = in.getInt();
            byte[] wordBytes = new byte[wordSize];
            in.get(wordBytes);
            String word = new String(wordBytes);
            float wordWeight = in.getFloat();
            words.add(new Pair<String, Float>(word, Float.valueOf(wordWeight)));
        }
        newTopic.words = words;
        return newTopic;
    }

    public List<TreeTopic> loadAll() {
        ArrayList<TreeTopic> topics = new ArrayList<TreeTopic>();
        try (RandomAccessFile in = new RandomAccessFile(this.filename, "r");){
            in.seek(this.start);
            if (this.end == 0L) {
                this.end = in.length();
            }
            byte[] buffer = new byte[(int)this.end - (int)this.start];
            in.read(buffer);
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            this.readHeader(byteBuffer);
            for (int i = 0; i < this.topicsCount; ++i) {
                TreeTopic newTopic = this.readTopic(byteBuffer);
                topics.add(newTopic);
                this.topicMap.put(newTopic.id, newTopic);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TreeTopicFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TreeTopicFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        return topics;
    }

    public TreeTopic load(int id) throws FileNotFoundException, IOException {
        TreeTopic topic = null;
        if (this.topicMap.containsKey(id)) {
            return this.topicMap.get(id);
        }
        try (RandomAccessFile in = new RandomAccessFile(this.filename, "r");){
            if (this.topicAddressMap.isEmpty()) {
                in.seek(this.start);
                this.readHeader(in);
                if (this.end == 0L) {
                    in.seek(in.length() - 8L);
                } else {
                    in.seek(this.end - 8L);
                }
                in.seek(in.readLong());
                for (int i = 0; i < this.topicsCount; ++i) {
                    int topicId = in.readInt();
                    long topicOffset = in.readLong();
                    this.topicAddressMap.put(topicId, topicOffset);
                }
            }
            if (this.topicAddressMap.containsKey(id)) {
                in.seek(this.topicAddressMap.get(id));
                topic = this.readTopic(in);
                this.topicMap.put(id, topic);
            }
        }
        return topic;
    }

    public String getTechnique() {
        return this.technique;
    }

    public void setTechnique(String technique) {
        this.technique = technique;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public static void main(String[] args) throws IOException {
        TreeTopicFile file = new TreeTopicFile("/home/renato/onetopic.topic");
        List<TreeTopic> topics = file.loadAll();
    }
}

