/*
 * Decompiled with CFR 0.152.
 */
package simpletree.io.tree;

import java.util.Stack;
import simpletree.io.tree.Node;

public class NewickConversor {
    public static Node parse(String newickString) {
        Stack<Node> nodeStack = new Stack<Node>();
        StringBuilder branchContent = new StringBuilder();
        Node parent = null;
        Node root = null;
        Node node = null;
        int level = -1;
        block6: for (int i = 0; i < newickString.length(); ++i) {
            switch (newickString.charAt(i)) {
                case '(': {
                    if (parent == null) {
                        root = parent = new Node();
                        node = null;
                        continue block6;
                    }
                    nodeStack.push(parent);
                    parent = new Node();
                    node = null;
                    continue block6;
                }
                case ',': {
                    if (node == null) {
                        node = new Node();
                    } else {
                        for (Node child : node.children) {
                            if (child.level < node.level) continue;
                            node.level = child.level + 1;
                        }
                    }
                    String[] branchValues = branchContent.toString().split(":");
                    node.id = Integer.valueOf(branchValues[0]);
                    node.parent = parent;
                    parent.children.add(node);
                    parent.distance.add(Double.valueOf(branchValues[1]));
                    branchContent = new StringBuilder();
                    node = null;
                    continue block6;
                }
                case ')': {
                    if (node == null) {
                        node = new Node();
                    } else {
                        for (Node child : node.children) {
                            if (child.level < node.level) continue;
                            node.level = child.level + 1;
                        }
                    }
                    String[] branchValues = branchContent.toString().split(":");
                    node.id = Integer.valueOf(branchValues[0]);
                    node.parent = parent;
                    parent.children.add(node);
                    parent.distance.add(Double.valueOf(branchValues[1]));
                    branchContent = new StringBuilder();
                    node = parent;
                    if (nodeStack.empty()) continue block6;
                    parent = (Node)nodeStack.pop();
                    continue block6;
                }
                case ';': {
                    String[] branchValues = branchContent.toString().split(":");
                    node.id = Integer.valueOf(branchValues[0]);
                    if (node.children.size() <= 0) continue block6;
                    for (Node child : node.children) {
                        if (child.level < node.level) continue;
                        node.level = child.level + 1;
                    }
                    continue block6;
                }
                default: {
                    branchContent.append(newickString.charAt(i));
                }
            }
        }
        return root;
    }

    public static String buildString(Node root) {
        StringBuilder result = new StringBuilder();
        NewickConversor.buildStringHelper(root, result);
        result.append(root.id);
        result.append(":0.0;");
        return result.toString();
    }

    private static void buildStringHelper(Node root, StringBuilder buffer) {
        buffer.append("(");
        for (int i = 0; i < root.children.size(); ++i) {
            Node child = root.children.get(i);
            if (child.children.size() > 0) {
                NewickConversor.buildStringHelper(child, buffer);
            }
            buffer.append(child.id);
            buffer.append(":");
            buffer.append(root.distance.get(i));
            if (i >= root.children.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append(")");
    }

    public static void main(String[] args) {
        String newickTree = "((51:10.000000000000000,49:10.000000000000000)96:4.142135623730951,50:10.000000000000000,52:10.000000000000000)97:0.0;";
        Node root = NewickConversor.parse(newickTree);
        String rebuiltString = NewickConversor.buildString(root);
        System.out.println("END!");
    }
}

