/*
 * Decompiled with CFR 0.152.
 */
package simpletree.layout.circular;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Stack;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.SimpleTree;
import simpletree.layout.TreeLayout;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class SupertreeCircularlLayout
implements TreeLayout {
    public int i;
    public int k;
    protected ArrayList<CircularNode> nodes;
    protected CircularNode root;

    @Override
    public SimpleTreeModel execute(SimpleTreeModel tree) {
        if (!this.init(tree)) {
            return tree;
        }
        this.i = 0;
        this.k = 0;
        for (CircularNode node : this.nodes) {
            node.distToParent = 1.0f / (1.0f + node.distToParent);
            if (!node.children.isEmpty()) continue;
            this.k += node.clusterSize + 1;
        }
        this.postorderTraversal(this.root);
        this.preorderTraversal(this.root);
        for (CircularNode node : this.nodes) {
            SimpleTreeInstance ti = tree.getInstanceById(node.id);
            if (ti == null) continue;
            ti.setX(node.x);
            ti.setY(node.y);
            ti.reservedAngle = node.w * 57.29578f;
            ti.angleRightBorder = node.t * 57.29578f;
        }
        return tree;
    }

    @Override
    public AbstractMatrix execute(SimpleTree tree) {
        this.init(tree);
        for (CircularNode node : this.nodes) {
            node.distToParent = 1.0f / (1.0f + node.distToParent);
        }
        this.postorderTraversal(this.root);
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.w = (float)Math.PI * 2;
        this.root.t = 0.0f;
        this.preorderTraversal(this.root);
        DenseMatrix position = new DenseMatrix();
        int size = this.nodes.size();
        for (int i = 0; i < size; ++i) {
            float[] vect = new float[]{this.nodes.get((int)i).x, this.nodes.get((int)i).y};
            ContentSimpleTree node = tree.getNode(i);
            DenseVector vector = new DenseVector(vect, node.getId(), 0.0f);
            position.addRow(vector);
        }
        return position;
    }

    protected void init(SimpleTree tree) {
        ArrayList<Edge> edges = tree.getEdges();
        int nrinstances = tree.getSize();
        this.nodes = new ArrayList();
        for (int i = 0; i < nrinstances; ++i) {
            int id = tree.getNode(i).getId();
            CircularNode node = new CircularNode(id);
            this.nodes.add(node);
            if (tree.getRootId() != id) continue;
            this.root = node;
        }
        for (Edge edge : edges) {
            CircularNode parent = this.getNode(edge.getSource());
            CircularNode ch = this.getNode(edge.getTarget());
            ch.parent = parent;
            ch.distToParent = edge.getWeight();
            parent.children.add(ch);
        }
    }

    protected boolean init(SimpleTreeModel tree) {
        if (tree.getSelectedConnectivity() == null) {
            return false;
        }
        ArrayList<Edge> edges = tree.getSelectedConnectivity().getEdges();
        ArrayList<AbstractInstance> instances = tree.getInstances();
        if (instances != null) {
            this.nodes = new ArrayList();
            for (AbstractInstance instance : instances) {
                int id = instance.getId();
                CircularNode node = new CircularNode(id);
                if (instance instanceof ClusterSimpleTreeInstance) {
                    if (((ClusterSimpleTreeInstance)instance).getCluster() != null) {
                        node.clusterSize = ((ClusterSimpleTreeInstance)instance).getCluster().getSize();
                    } else if (((ClusterSimpleTreeInstance)instance).getTreeCluster() != null) {
                        node.clusterSize = ((ClusterSimpleTreeInstance)instance).getTreeCluster().getSize();
                    }
                }
                this.nodes.add(node);
                if (tree.getRoot() != id) continue;
                this.root = node;
            }
            if (tree.getRoot() == -1) {
                this.root = this.nodes.get(instances.size() - 1);
            }
            Stack<SimpleTreeInstance> instancesStack = new Stack<SimpleTreeInstance>();
            instancesStack.add(tree.getInstanceById(tree.getRoot()));
            while (!instancesStack.isEmpty()) {
                SimpleTreeInstance currentNode = (SimpleTreeInstance)instancesStack.pop();
                CircularNode node = this.getNode(currentNode.getId());
                if (!currentNode.hasChildren()) continue;
                for (int i = 0; i < currentNode.getNumChildren(); ++i) {
                    instancesStack.add(tree.getInstanceById(currentNode.getChildrenId(i)));
                    CircularNode child = this.getNode(currentNode.getChildrenId(i));
                    child.parent = node;
                    child.distToParent = currentNode.childrenDist[i];
                    node.children.add(child);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    protected void postorderTraversal(CircularNode v) {
        for (CircularNode child : v.children) {
            this.postorderTraversal(child);
        }
        if (v.children.isEmpty()) {
            v.c = 0.0f;
            v.t = (float)(Math.PI * 2 * (double)this.i) / (float)this.k;
            v.w = (float)(Math.PI * 2 * (double)(this.i + v.clusterSize + 1) / (double)this.k) - v.t;
            v.x = (float)Math.cos(Math.PI * 2 * (double)(this.i + (v.clusterSize + 1) / 2) / (double)this.k);
            v.y = (float)Math.sin(Math.PI * 2 * (double)(this.i + (v.clusterSize + 1) / 2) / (double)this.k);
            this.i += v.clusterSize + 1;
        } else {
            v.s = 0.0f;
            if (v.parent != null) {
                v.s = 1.0f / v.distToParent;
            }
            for (CircularNode w : v.children) {
                if (v == this.root) {
                    v.s += 1.0f / w.distToParent;
                    continue;
                }
                v.s += 1.0f / (w.distToParent * (float)v.children.size());
            }
            float t = 0.0f;
            Point2D.Float taux = new Point2D.Float(0.0f, 0.0f);
            for (CircularNode w : v.children) {
                float se = 1.0f / (w.distToParent * (float)v.children.size());
                t += se / v.s * w.c;
                taux.x += se / v.s * w.x;
                taux.y += se / v.s * w.y;
            }
            if (v != this.root) {
                v.c = 1.0f / v.distToParent / (v.s * (1.0f - t));
            }
            v.x = taux.x / (1.0f - t);
            v.y = taux.y / (1.0f - t);
        }
    }

    private void preorderTraversal(CircularNode v) {
        if (v != this.root) {
            CircularNode parent = v.parent;
            v.x = v.c * parent.x + v.x;
            v.y = v.c * parent.y + v.y;
        }
        for (CircularNode w : v.children) {
            this.preorderTraversal(w);
        }
    }

    protected CircularNode getNode(int id) {
        for (CircularNode node : this.nodes) {
            if (node.id != id) continue;
            return node;
        }
        return null;
    }

    public class CircularNode {
        public int id;
        public float x;
        public float y;
        public CircularNode parent;
        public float distToParent;
        public ArrayList<CircularNode> children = new ArrayList();
        public int clusterSize = 0;
        public float c;
        public float s;
        public float w;
        public float t;

        public CircularNode(int id) {
            this.id = id;
        }

        public String toString() {
            return Integer.toString(this.id);
        }
    }
}

