/*
 * Decompiled with CFR 0.152.
 */
package simpletree.layout.radial;

import java.util.ArrayList;
import java.util.Stack;
import simpletree.basics.ClusterContentSimpleTree;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.SimpleTree;
import simpletree.layout.radial.RadialLayout;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.Edge;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class SupertreeRadialLayout
extends RadialLayout {
    @Override
    protected void postorderTraversal(RadialLayout.Node v) {
        if (v.children.isEmpty()) {
            v.l = 1.0f;
            v.l += (float)v.clusterSize;
        } else {
            v.l = 0.0f;
            v.l += (float)v.clusterSize;
            for (RadialLayout.Node w : v.children) {
                this.postorderTraversal(w);
                v.l += w.l;
            }
        }
    }

    @Override
    protected void init(SimpleTree tree) {
        ArrayList<Edge> edges = tree.getEdges();
        int nrinstances = tree.getSize();
        this.nodes = new ArrayList();
        for (int i = 0; i < nrinstances; ++i) {
            ContentSimpleTree simpleTreeNode = tree.getNode(i);
            int id = tree.getNode(i).getId();
            RadialLayout.Node node = new RadialLayout.Node(id);
            if (simpleTreeNode instanceof ClusterContentSimpleTree) {
                node.clusterSize = ((ClusterContentSimpleTree)simpleTreeNode).getCluster().getSize();
            }
            this.nodes.add(node);
            if (tree.getRootId() != id) continue;
            this.root = node;
        }
        for (Edge edge : edges) {
            RadialLayout.Node parent = this.getNode(edge.getSource());
            RadialLayout.Node ch = this.getNode(edge.getTarget());
            ch.parent = parent;
            ch.dist = edge.getWeight();
            parent.children.add(ch);
        }
    }

    @Override
    protected boolean init(SimpleTreeModel tree) {
        if (tree.getSelectedConnectivity() == null) {
            return false;
        }
        ArrayList<Edge> edges = tree.getSelectedConnectivity().getEdges();
        ArrayList<AbstractInstance> instances = tree.getInstances();
        if (instances == null) {
            return false;
        }
        this.nodes = new ArrayList();
        for (AbstractInstance instance : instances) {
            int id = instance.getId();
            RadialLayout.Node node = new RadialLayout.Node(id);
            if (instance instanceof ClusterSimpleTreeInstance) {
                if (((ClusterSimpleTreeInstance)instance).getCluster() != null) {
                    node.clusterSize = ((ClusterSimpleTreeInstance)instance).getCluster().getSize();
                } else if (((ClusterSimpleTreeInstance)instance).getTreeCluster() != null) {
                    node.clusterSize = ((ClusterSimpleTreeInstance)instance).getTreeCluster().getSize();
                }
            }
            this.nodes.add(node);
            if (tree.getRoot() != id) continue;
            this.root = node;
        }
        if (tree.getRoot() == -1) {
            this.root = (RadialLayout.Node)this.nodes.get(instances.size() - 1);
        }
        Stack<SimpleTreeInstance> instancesStack = new Stack<SimpleTreeInstance>();
        instancesStack.add(tree.getInstanceById(tree.getRoot()));
        while (!instancesStack.isEmpty()) {
            SimpleTreeInstance currentNode = (SimpleTreeInstance)instancesStack.pop();
            RadialLayout.Node node = this.getNode(currentNode.getId());
            if (!currentNode.hasChildren()) continue;
            for (int i = 0; i < currentNode.getNumChildren(); ++i) {
                instancesStack.add(tree.getInstanceById(currentNode.getChildrenId(i)));
                RadialLayout.Node child = this.getNode(currentNode.getChildrenId(i));
                child.parent = node;
                child.dist = currentNode.childrenDist[i];
                node.children.add(child);
            }
        }
        return true;
    }
}

