/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractVector;

public abstract class AbstractMatrix
implements Cloneable {
    protected int dimensions;
    protected ArrayList<String> attributes = new ArrayList();
    protected ArrayList<String> labels = new ArrayList();
    protected ArrayList<AbstractVector> rows = new ArrayList();

    public abstract void load(String var1) throws IOException;

    public abstract void save(String var1) throws IOException;

    public abstract Object clone() throws CloneNotSupportedException;

    public boolean contains(AbstractVector vector) {
        return this.rows.contains(vector);
    }

    public void addRow(AbstractVector vector) {
        assert (this.rows.isEmpty() || this.dimensions == vector.size()) : "ERROR: vector of wrong size!";
        this.rows.add(vector);
        this.dimensions = vector.size();
    }

    public void addRow(AbstractVector vector, String label) {
        assert (this.rows.isEmpty() || this.dimensions == vector.size()) : "ERROR: vector of wrong size!";
        this.labels.add(label);
        this.rows.add(vector);
        this.dimensions = vector.size();
    }

    public void setRow(int index, AbstractVector vector) {
        assert (this.rows.size() > index && this.dimensions == vector.size()) : "ERROR: wrong index or vector of wrong size!";
        this.rows.set(index, vector);
    }

    public void setRow(int index, AbstractVector vector, String label) {
        assert (this.rows.size() > index && this.dimensions == vector.size() || this.labels.size() > index && this.dimensions == vector.size()) : "ERROR: wrong index or vector of wrong size!";
        this.labels.set(index, label);
        this.rows.set(index, vector);
    }

    public AbstractVector removeRow(int index) {
        assert (this.rows.size() > index) : "ERROR: wrong index!";
        if (this.labels.size() > 0) {
            this.labels.remove(index);
        }
        return this.rows.remove(index);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public ArrayList<AbstractVector> getRows() {
        return this.rows;
    }

    public AbstractVector getRow(int row) {
        assert (this.rows.size() > row) : "ERROR: this row does not exists in the matrix!";
        return this.rows.get(row);
    }

    public String getLabel(int row) {
        assert ((this.labels.isEmpty() || this.labels.size() > row) && this.rows.size() > row) : "ERROR: this row does not exists in the labels!";
        if (this.labels.size() > 0) {
            return this.labels.get(row);
        }
        return Integer.toString(this.rows.get(row).getId());
    }

    public void setLabels(ArrayList<String> labels) {
        assert (this.labels.isEmpty() || this.rows.size() == labels.size()) : "ERROR: labels and matrix of different sizes!";
        this.labels = labels;
    }

    public void normalize() {
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            if (!this.rows.get(i).isNull()) {
                this.rows.get(i).normalize();
                continue;
            }
            Logger.getLogger(AbstractMatrix.class.getName()).log(Level.INFO, "Ignoring null vector on the normalization.");
        }
    }

    public float[][] toMatrix() {
        float[][] matrix = new float[this.rows.size()][];
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            matrix[i] = this.rows.get(i).toArray();
        }
        return matrix;
    }

    public ArrayList<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ArrayList<String> attributes) {
        assert (this.rows.isEmpty() || this.dimensions == attributes.size()) : "ERROR: attributes and vectors of different sizes!";
        this.attributes = attributes;
    }

    public ArrayList<Integer> getIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            ids.add(this.rows.get(i).getId());
        }
        return ids;
    }

    public float[] getClassData() {
        float[] cdata = new float[this.rows.size()];
        for (int i = 0; i < cdata.length; ++i) {
            cdata[i] = this.rows.get(i).getKlass();
        }
        return cdata;
    }

    public ArrayList<String> getLabels() {
        return this.labels;
    }
}

