/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix;

import java.io.BufferedWriter;
import java.io.IOException;

public abstract class AbstractVector {
    protected float[] values;
    protected float norm = 0.0f;
    protected boolean updateNorm = true;
    protected int size = 0;
    protected int id = 0;
    protected float klass = 0.0f;
    protected static final float DELTA = 1.0E-5f;

    public abstract void normalize();

    public abstract float dot(AbstractVector var1);

    public abstract float[] toArray();

    public abstract float getValue(int var1);

    public abstract void setValue(int var1, float var2);

    public abstract void write(BufferedWriter var1) throws IOException;

    public abstract Object clone() throws CloneNotSupportedException;

    protected abstract void create(float[] var1, int var2, float var3);

    protected abstract void updateNorm();

    public float norm() {
        if (this.updateNorm) {
            this.updateNorm();
        }
        return this.norm;
    }

    public void shouldUpdateNorm() {
        this.updateNorm = true;
    }

    public int size() {
        return this.size;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public float getKlass() {
        return this.klass;
    }

    public void setKlass(float klass) {
        this.klass = klass;
    }

    public boolean isNull() {
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (!(Math.abs(this.values[i]) > 0.0f)) continue;
                return false;
            }
        }
        return true;
    }

    public float[] getValues() {
        return this.values;
    }
}

