/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.dense;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseVector;
import simpletree.util.Util;

public class DenseMatrix
extends AbstractMatrix {
    @Override
    public void addRow(AbstractVector vector) {
        assert (vector instanceof DenseVector) : "ERROR: vector of wrong type!";
        super.addRow(vector);
    }

    @Override
    public void setRow(int index, AbstractVector vector) {
        assert (vector instanceof DenseVector) : "ERROR: vector of wrong type!";
        super.setRow(index, vector);
    }

    @Override
    public void load(String filename) throws IOException {
        this.rows = new ArrayList();
        this.attributes = new ArrayList();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(filename));
            char[] header = in.readLine().trim().toCharArray();
            if (header.length != 2) {
                throw new IOException("Wrong format of header information.");
            }
            if (header[0] != 'D') {
                throw new IOException("Wrong matrix format. It is not the dense format.");
            }
            int nrobjs = Integer.parseInt(in.readLine());
            int nrdims = Integer.parseInt(in.readLine());
            String line = in.readLine();
            StringTokenizer t1 = new StringTokenizer(line, ";");
            while (t1.hasMoreTokens()) {
                String token = t1.nextToken();
                this.attributes.add(token.trim());
            }
            if (this.attributes.size() > 0 && this.attributes.size() != nrdims) {
                throw new IOException("The number of attributes does not match with the dimensionality of matrix (" + this.attributes.size() + " - " + nrdims + ").");
            }
            int lineIndex = 0;
            while ((line = in.readLine()) != null && line.trim().length() > 0) {
                StringTokenizer t2 = new StringTokenizer(line, ";");
                String id = t2.nextToken().trim();
                float klass = 0.0f;
                float[] vector = new float[nrdims];
                int index = 0;
                while (t2.hasMoreTokens()) {
                    String token = t2.nextToken();
                    float value = Float.parseFloat(token.trim());
                    if (header[1] == 'Y') {
                        if (t2.hasMoreTokens()) {
                            if (index < nrdims) {
                                vector[index] = value;
                                ++index;
                                continue;
                            }
                            throw new IOException("Vector with wrong number of dimensions!");
                        }
                        klass = value;
                        continue;
                    }
                    if (header[1] == 'N') {
                        if (index < nrdims) {
                            vector[index] = value;
                            ++index;
                            continue;
                        }
                        throw new IOException("Vector with wrong number of dimensions!");
                    }
                    throw new IOException("Unknown class data option");
                }
                if (Util.isParsableToInt(id)) {
                    this.addRow(new DenseVector(vector, Integer.parseInt(id), klass));
                } else {
                    this.addRow(new DenseVector(vector, lineIndex, klass), id);
                }
                ++lineIndex;
            }
            if (this.getRowCount() != nrobjs) {
                throw new IOException("The number of vectors does not match with the matrix size (" + this.getRowCount() + " - " + nrobjs + ").");
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File " + filename + " does not exist!");
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public void save(String filename) throws IOException {
        BufferedWriter out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(filename));
            out.write("DY\r\n");
            out.write(Integer.toString(this.getRowCount()));
            out.write("\r\n");
            out.write(Integer.toString(this.getDimensions()));
            out.write("\r\n");
            if (this.attributes != null) {
                for (i = 0; i < this.attributes.size(); ++i) {
                    out.write(((String)this.attributes.get(i)).replaceAll("<>", " ").trim());
                    if (i >= this.attributes.size() - 1) continue;
                    out.write(";");
                }
                out.write("\r\n");
            } else {
                out.write("\r\n");
            }
            for (i = 0; i < this.getRowCount(); ++i) {
                if (this.labels.size() > 0) {
                    out.write((String)this.labels.get(i));
                } else {
                    out.write(Integer.toString(((AbstractVector)this.rows.get(i)).getId()));
                }
                out.write(";");
                ((AbstractVector)this.rows.get(i)).write(out);
                out.write("\r\n");
            }
        }
        catch (IOException ex) {
            throw new IOException("Problems written \"" + filename + "\"!");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DenseMatrix.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DenseMatrix clone = new DenseMatrix();
        clone.dimensions = this.dimensions;
        for (String lab : this.labels) {
            clone.labels.add(lab);
        }
        for (String attr : this.attributes) {
            clone.attributes.add(attr);
        }
        for (AbstractVector v : this.rows) {
            clone.rows.add((DenseVector)v.clone());
        }
        return clone;
    }
}

