/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.reader;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;

public class BinaryMatrixReader {
    public DenseMatrix read(String filename) throws IOException {
        int i;
        DenseMatrix matrix = new DenseMatrix();
        ArrayList<Float> cdata = new ArrayList<Float>();
        float[][] points = this.read(filename, cdata);
        ArrayList<String> attrib = new ArrayList<String>();
        for (i = 0; i < points[0].length; ++i) {
            attrib.add("attr");
        }
        matrix.setAttributes(attrib);
        for (i = 0; i < points.length; ++i) {
            matrix.addRow(new DenseVector(points[i], i, cdata.get(i).floatValue()));
        }
        return matrix;
    }

    private float[][] read(String filename, ArrayList<Float> cdata) throws IOException {
        BufferedInputStream bis = null;
        FilterInputStream dis = null;
        try {
            int i;
            bis = new BufferedInputStream(new FileInputStream(filename));
            dis = new DataInputStream(bis);
            int nrelements = ((DataInputStream)dis).readInt();
            int nrdimensions = ((DataInputStream)dis).readInt();
            float[][] points = new float[nrelements][];
            for (i = 0; i < points.length; ++i) {
                points[i] = new float[nrdimensions];
            }
            for (i = 0; i < points.length; ++i) {
                for (int j = 0; j < points[i].length; ++j) {
                    points[i][j] = ((DataInputStream)dis).readFloat();
                }
                cdata.add(Float.valueOf(((DataInputStream)dis).readFloat()));
            }
            float[][] fArrayArray = points;
            return fArrayArray;
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException ex) {
                throw new IOException(ex);
            }
        }
    }
}

