/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.streaming;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.streaming.StreamingVector;

public class StreamingMatrix
extends AbstractMatrix {
    private int nrrows;
    private RandomAccessFile raf;
    private static final int FLOAT_SIZE = 4;

    @Override
    public void load(String filename) throws IOException {
        this.raf = new RandomAccessFile(filename, "r");
        this.nrrows = this.raf.readInt();
        this.dimensions = this.raf.readInt();
    }

    @Override
    public int getRowCount() {
        return this.nrrows;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public AbstractVector getRow(int row) {
        if (this.raf != null) {
            try {
                int offset = 8 + row * (this.dimensions + 1) * 4;
                this.raf.seek(offset);
                float[] vect = new float[this.dimensions];
                byte[] bytes = new byte[(this.dimensions + 1) * 4];
                this.raf.readFully(bytes);
                int start = 0;
                for (int i = 0; i < this.dimensions; ++i) {
                    vect[i] = this.toFloat(bytes, start);
                    start += 4;
                }
                float cdata = this.toFloat(bytes, this.dimensions * 4);
                return new StreamingVector(vect, row, cdata);
            }
            catch (IOException ex) {
                Logger.getLogger(StreamingMatrix.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    @Override
    public void save(String filename) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addRow(AbstractVector vector) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setRow(int index, AbstractVector vector) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractVector removeRow(int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void normalize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[][] toMatrix() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArrayList<String> getAttributes() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAttributes(ArrayList<String> attributes) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ArrayList<Integer> getIds() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < this.nrrows; ++i) {
            ids.add(i);
        }
        return ids;
    }

    @Override
    public float[] getClassData() {
        float[] klass = new float[this.nrrows];
        for (int i = 0; i < this.nrrows; ++i) {
            AbstractVector row = this.getRow(i);
            klass[i] = row.getKlass();
        }
        return klass;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private final float toFloat(byte[] b, int start) {
        int i = (b[start] & 0xFF) << 24 | (b[start + 1] & 0xFF) << 16 | (b[start + 2] & 0xFF) << 8 | b[start + 3] & 0xFF;
        return Float.intBitsToFloat(i);
    }
}

