/*
 * Decompiled with CFR 0.152.
 */
package simpletree.matrix.writer;

import java.io.IOException;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.writer.MatrixWriterParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Points.Output", name="Points matrix writer", description="Write a Points Matrix to a file.")
public class MatrixWriterComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient MatrixWriterParamView paramview;
    private transient AbstractMatrix matrix;

    public void execute() throws IOException {
        if (this.filename.trim().length() <= 0) {
            throw new IOException("A matrix file name must be provided to write.");
        }
        this.matrix.save(this.filename);
    }

    public void input(@Param(name="matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new MatrixWriterParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

