/*
 * Decompiled with CFR 0.152.
 */
package simpletree.mesh;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mesh2d.basic.Cell;
import mesh2d.graph.Vertex;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.io.cluster.TreeCluster;
import simpletree.io.file.SupertreeFile;
import simpletree.io.topic.TreeTopic;
import simpletree.io.util.Pair;
import simpletree.mesh.CellTopic;
import simpletree.mesh.TreeVoronoi;
import simpletree.model.AbstractInstance;
import simpletree.model.ClusterSimpleTreeInstance;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.projectioncloud.fill.Group;
import simpletree.projectioncloud.topic.Term;

public class TreeCloud
extends TreeVoronoi {
    private Map<Integer, Group> cloudMap = new HashMap<Integer, Group>();
    private Map<Integer, Integer> activeTopicMap = new HashMap<Integer, Integer>();
    private Map<Integer, ArrayList<CellTopic>> topicMap = new HashMap<Integer, ArrayList<CellTopic>>();
    public int maxWordsPerCell = 10;
    public List<TreeTopic> treeTopics = null;

    public TreeCloud(SimpleTreeModel model) {
        super(model);
    }

    private TreeTopic getTopicById(int id) {
        TreeTopic topic = null;
        for (TreeTopic t : this.treeTopics) {
            if (t.id != id) continue;
            topic = t;
            break;
        }
        return topic;
    }

    @Override
    public void build(Rectangle boundingBox) {
        this.image = null;
        this.boundingBox = boundingBox;
        List allVertices = this.graph.getVertices();
        ArrayList<Vertex> validVertices = new ArrayList<Vertex>();
        for (Vertex v : allVertices) {
            if (!v.isValid()) continue;
            validVertices.add(v);
        }
        this.graph.setVertices(validVertices);
        super.build(boundingBox);
        this.graph.setVertices(allVertices);
        for (int i = 0; i < this.cellList.size(); ++i) {
            Group group;
            Cell cell;
            block19: {
                ArrayList<Serializable> instancesInCell;
                cell = (Cell)this.cellList.get(i);
                group = null;
                if (this.model.getSupertreeFile() != null || this.treeTopics != null) {
                    try {
                        instancesInCell = this.clusterInstancesInCell(cell);
                        if (instancesInCell.isEmpty()) continue;
                        group = new Group(null);
                        if (this.topicMap.containsKey(cell.getId())) {
                            int activeTopic = this.activeTopicMap.get(cell.getId());
                            CellTopic topic = this.topicMap.get(cell.getId()).get(activeTopic);
                            group.setTerms(topic.terms);
                            break block19;
                        }
                        ArrayList<CellTopic> cellTopicList = new ArrayList<CellTopic>();
                        SupertreeFile stFile = this.model.getSupertreeFile();
                        for (ClusterSimpleTreeInstance clusterSimpleTreeInstance : instancesInCell) {
                            int j;
                            List<Pair<String, Float>> clusterWords;
                            ArrayList<Term> topicTerms = new ArrayList<Term>();
                            TreeTopic clusterTopic = null;
                            clusterTopic = stFile != null ? stFile.Topic.getById(clusterSimpleTreeInstance.getId()) : this.getTopicById(clusterSimpleTreeInstance.getId());
                            if (clusterTopic == null) {
                                clusterWords = new ArrayList<Pair<String, Float>>();
                                for (TreeCluster subCluster : clusterSimpleTreeInstance.getTreeCluster().getSubClusterList()) {
                                    List<Pair<String, Float>> subclusterWords = stFile != null ? stFile.Topic.getById((int)subCluster.getId()).words : this.getTopicById((int)subCluster.getId()).words;
                                    if (subclusterWords == null) continue;
                                    clusterWords.addAll(subclusterWords);
                                }
                            } else {
                                clusterWords = clusterTopic.words;
                            }
                            if (clusterWords == null || clusterWords.isEmpty()) continue;
                            Collections.sort(clusterWords, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    Pair p1 = (Pair)o1;
                                    Pair p2 = (Pair)o2;
                                    return Float.compare(((Float)p2.second).floatValue(), ((Float)p1.second).floatValue());
                                }
                            });
                            if (clusterWords.size() > this.maxWordsPerCell) {
                                for (j = 0; j < this.maxWordsPerCell; ++j) {
                                    topicTerms.add(new Term((String)clusterWords.get((int)j).first, ((Float)clusterWords.get((int)j).second).floatValue()));
                                }
                            } else {
                                for (j = 0; j < clusterWords.size(); ++j) {
                                    topicTerms.add(new Term((String)clusterWords.get((int)j).first, ((Float)clusterWords.get((int)j).second).floatValue()));
                                }
                            }
                            cellTopicList.add(new CellTopic(topicTerms));
                            if (clusterSimpleTreeInstance.getTreeCluster() == null || clusterSimpleTreeInstance.getTreeCluster().getSubClusterList().isEmpty()) continue;
                            for (TreeCluster subCluster : clusterSimpleTreeInstance.getTreeCluster().getSubClusterList()) {
                                topicTerms = new ArrayList();
                                List<Pair<String, Float>> words = null;
                                words = stFile != null ? stFile.Topic.getById((int)subCluster.getId()).words : this.getTopicById((int)subCluster.getId()).words;
                                for (Pair<String, Float> word : words) {
                                    topicTerms.add(new Term((String)word.first, ((Float)word.second).floatValue()));
                                }
                                cellTopicList.add(new CellTopic(topicTerms));
                            }
                        }
                        this.activeTopicMap.put(cell.getId(), 0);
                        this.topicMap.put(cell.getId(), cellTopicList);
                        if (cellTopicList.isEmpty()) continue;
                        group.setTerms(((CellTopic)cellTopicList.get((int)0)).terms);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TreeCloud.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    instancesInCell = this.instancesInCell(cell);
                    if (instancesInCell.isEmpty()) continue;
                    group = new Group(instancesInCell);
                    try {
                        group.calculateTerms(this.model.getMatrix());
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TreeCloud.class.getName()).log(Level.SEVERE, null, ex);
                        continue;
                    }
                }
            }
            if (group == null || group.getTerms().isEmpty()) continue;
            group.setPolygon(cell.getShape());
            group.fillPolygon();
            this.cloudMap.put(cell.getId(), group);
        }
    }

    @Override
    protected ArrayList<Integer> instancesInCell(Cell cell) {
        ArrayList<Integer> intoCellList = new ArrayList<Integer>();
        for (AbstractInstance inst : this.model.getInstances()) {
            SimpleTreeInstance treeInst = (SimpleTreeInstance)inst;
            if (!treeInst.isValid() || !cell.contains((int)treeInst.getX(), (int)treeInst.getY()) || !(treeInst instanceof ClusterSimpleTreeInstance)) continue;
            Cluster nodeCluster = ((ClusterSimpleTreeInstance)treeInst).getCluster();
            intoCellList.addAll(nodeCluster.getItemList());
            intoCellList.addAll(nodeCluster.getMedoidList());
        }
        return intoCellList;
    }

    protected ArrayList<ClusterSimpleTreeInstance> clusterInstancesInCell(Cell cell) {
        ArrayList<ClusterSimpleTreeInstance> intoCellList = new ArrayList<ClusterSimpleTreeInstance>();
        for (AbstractInstance inst : this.model.getInstances()) {
            SimpleTreeInstance treeInst = (SimpleTreeInstance)inst;
            if (!treeInst.isValid() || !cell.contains((int)treeInst.getX(), (int)treeInst.getY()) || !(treeInst instanceof ClusterSimpleTreeInstance)) continue;
            intoCellList.add((ClusterSimpleTreeInstance)treeInst);
        }
        return intoCellList;
    }

    @Override
    public void setAlpha(float alpha) {
        this.alpha = alpha;
        this.image = null;
    }

    @Override
    public void setBackgroundAlpha(float backgroundAlpha) {
        this.backgroundAlpha = backgroundAlpha;
        this.image = null;
    }

    @Override
    public void setEdgeAlpha(float edgeAlpha) {
        this.edgeAlpha = edgeAlpha;
        this.image = null;
    }

    @Override
    public void paint(Graphics2D g2, boolean highQualityRender) {
        if (this.image == null) {
            this.image = new BufferedImage(this.boundingBox.width, this.boundingBox.height, 2);
            Graphics2D imageGraphics = this.image.createGraphics();
            super.paint(imageGraphics, true);
            for (Cell cell : this.cellList) {
                Group group = this.cloudMap.get(cell.getId());
                if (group == null) continue;
                if (cell.isSelected()) {
                    imageGraphics.setComposite(AlphaComposite.getInstance(3, 1.0f));
                } else {
                    imageGraphics.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
                }
                group.draw(imageGraphics, highQualityRender);
            }
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    @Override
    public void scrollUp(Cell cell) {
        int cellId = cell.getId();
        int topicIndex = this.activeTopicMap.get(cellId);
        ++topicIndex;
        this.activeTopicMap.put(cellId, topicIndex %= this.topicMap.get(cellId).size());
        this.image = null;
    }

    @Override
    public void scrollDown(Cell cell) {
        int cellId = cell.getId();
        int topicIndex = this.activeTopicMap.get(cellId);
        if (--topicIndex < 0) {
            topicIndex = this.topicMap.get(cellId).size() - 1;
        }
        this.activeTopicMap.put(cellId, topicIndex);
        this.image = null;
    }
}

