/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import simpletree.model.GraphInstance;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeModel;

public class SimpleTreeInstance
extends GraphInstance
implements Serializable {
    private int recursiveChildCount;
    public float distanceToRoot = 0.0f;
    public float normalizedDistanceToRoot = 0.0f;
    private int parent;
    private int[] children;
    public float[] childrenDist;
    public int level;
    public boolean marked = false;
    public float reservedAngle = 0.0f;
    public float angleRightBorder = 0.0f;
    public int multiscaleLevel = -1;
    protected boolean showImage = false;

    public SimpleTreeInstance createClone(SimpleTreeModel model) {
        Scalar selscalar = model.getSelectedScalar();
        SimpleTreeInstance ins = new SimpleTreeInstance(model, this.id, this.isValid());
        ins.setColor(this.getColor());
        ins.setParent(this.getParent());
        ins.setScalarValue(selscalar, this.getScalarValue(selscalar));
        ins.setSelected(this.isSelected());
        ins.setShowLabel(this.isShowLabel());
        ins.setSizeFactor(this.getSizeFactor());
        ins.setX(this.getX());
        ins.setY(this.getY());
        ins.fdata = this.fdata;
        ins.scalars = new ArrayList();
        for (Float scalar : this.scalars) {
            ins.scalars.add(scalar);
        }
        if (ins.children.length != this.children.length) {
            ins.children = new int[this.children.length];
            ins.childrenDist = new float[this.children.length];
        }
        System.arraycopy(this.children, 0, ins.children, 0, this.children.length);
        System.arraycopy(this.childrenDist, 0, ins.childrenDist, 0, this.childrenDist.length);
        ins.parent = this.parent;
        return ins;
    }

    public SimpleTreeInstance(SimpleTreeModel model, int id, float x, float y, boolean valid) {
        super(id, x, y);
        this.setModel(model);
        model.addInstance(this);
        this.setValid(valid);
        this.children = new int[3];
        this.childrenDist = new float[3];
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i] = -1;
            this.childrenDist[i] = -1.0f;
        }
    }

    public SimpleTreeInstance(SimpleTreeModel model, int id, boolean valid) {
        this(model, id, 0.0f, 0.0f, valid);
    }

    public SimpleTreeInstance(SimpleTreeModel model, int id) {
        this(model, id, 0.0f, 0.0f, false);
    }

    @Override
    public String toString() {
        return Integer.toString(this.id);
    }

    public void draw(Graphics2D g2, boolean highquality) {
        int xaux;
        SimpleTreeModel tmodel = (SimpleTreeModel)this.model;
        Rectangle boundingBox = new Rectangle(tmodel.getSize());
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int n = (int)this.x <= 0 ? 1 : (xaux = (int)this.x < (int)boundingBox.getWidth() ? (int)this.x : (int)boundingBox.getWidth() - 1);
        int yaux = (int)this.y <= 0 ? 1 : ((int)this.y < (int)boundingBox.getHeight() ? (int)this.y : (int)boundingBox.getHeight() - 1);
        int inssize = tmodel.getInstanceSize();
        float alpha = tmodel.getAlpha();
        if (tmodel.getSelectedInstances() == null || tmodel.getSelectedInstances().isEmpty() || tmodel.isNoAlpha()) {
            alpha = 1.0f;
        }
        if (tmodel.isDrawAsImage()) {
            Image rimg;
            if (((SimpleTreeModel)this.model).getImages() != null && (rimg = ((SimpleTreeModel)this.model).getImages().get(this.id)) != null) {
                int imgSize = tmodel.getImagesSize();
                Image img = rimg.getScaledInstance(imgSize * 5, imgSize * 5, 0);
                int w = img.getWidth(null);
                int h = img.getHeight(null);
                g2.drawImage(img, xaux - w / 2, yaux - h / 2, null);
                if (((SimpleTreeModel)this.model).isDrawImageFrame()) {
                    g2.setStroke(new BasicStroke(3.0f));
                    g2.setColor(this.getColor());
                    g2.drawRect(xaux - w / 2 - 2, yaux - h / 2 - 2, w + 3, h + 3);
                    g2.setStroke(new BasicStroke(1.0f));
                }
                if (this.selected) {
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.setColor(Color.RED);
                    g2.drawRect((int)this.x - w / 2, (int)this.y - h / 2, w, h);
                    g2.setStroke(new BasicStroke(1.0f));
                }
            }
        } else {
            if (this.selected || !this.isValid()) {
                alpha = 1.0f;
            }
            if (this.isValid()) {
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                g2.setColor(this.color);
                g2.fillOval(xaux - inssize, yaux - inssize, inssize * 2, inssize * 2);
                g2.setColor(Color.BLACK);
                g2.drawOval(xaux - inssize, yaux - inssize, inssize * 2, inssize * 2);
            } else {
                inssize /= 2;
                if (tmodel.getRoot() == this.id) {
                    g2.setColor(Color.BLACK);
                } else {
                    g2.setColor(Color.WHITE);
                }
                g2.fillOval(xaux - inssize, yaux - inssize, inssize * 2, inssize * 2);
                g2.setColor(Color.GRAY);
                g2.drawOval(xaux - inssize, yaux - inssize, inssize * 2, inssize * 2);
            }
            if (this.marked) {
                g2.setColor(Color.GRAY);
                g2.drawOval(xaux - inssize, yaux - inssize, inssize * 4, inssize * 4);
            }
            g2.setStroke(new BasicStroke(1.0f));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
    }

    @Override
    public void draw(BufferedImage image, boolean highquality) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.draw(g2, highquality);
    }

    public void drawHighlight(Graphics2D g2, boolean highquality) {
        int xaux;
        SimpleTreeModel tmodel = (SimpleTreeModel)this.model;
        Rectangle boundingBox = new Rectangle(tmodel.getSize());
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int n = (int)this.x <= 0 ? 1 : (xaux = (int)this.x < (int)boundingBox.getWidth() ? (int)this.x : (int)boundingBox.getWidth() - 1);
        int yaux = (int)this.y <= 0 ? 1 : ((int)this.y < (int)boundingBox.getHeight() ? (int)this.y : (int)boundingBox.getHeight() - 1);
        int inssize = tmodel.getInstanceSize();
        float alpha = tmodel.getAlpha();
        if (tmodel.getSelectedInstances() == null || tmodel.getSelectedInstances().isEmpty() || tmodel.isNoAlpha()) {
            alpha = 1.0f;
        }
        if (((SimpleTreeModel)this.model).isDrawAsImage()) {
            Image rimg;
            if (((SimpleTreeModel)this.model).getImages() != null && (rimg = ((SimpleTreeModel)this.model).getImages().get(this.id)) != null) {
                int imgSize = tmodel.getImagesSize();
                Image img = rimg.getScaledInstance(imgSize * 5, imgSize * 5, 0);
                int w = img.getWidth(null);
                int h = img.getHeight(null);
                g2.drawImage(img, xaux - w / 2, yaux - h / 2, null);
                if (((SimpleTreeModel)this.model).isDrawImageFrame()) {
                    g2.setStroke(new BasicStroke(3.0f));
                    g2.setColor(this.getColor());
                    g2.drawRect(xaux - w / 2 - 2, yaux - h / 2 - 2, w + 3, h + 3);
                    g2.setStroke(new BasicStroke(1.0f));
                }
                if (this.selected) {
                    g2.setStroke(new BasicStroke(2.0f));
                    g2.setColor(Color.RED);
                    g2.drawRect((int)this.x - w / 2, (int)this.y - h / 2, w, h);
                    g2.setStroke(new BasicStroke(1.0f));
                }
            }
        } else {
            alpha = 0.3f;
            int ringSize = 10;
            if (this.isValid()) {
                g2.setComposite(AlphaComposite.getInstance(3, alpha));
                g2.setColor(this.color);
                g2.fillOval(xaux - inssize * ringSize / 2, yaux - inssize * (ringSize / 2), inssize * ringSize, inssize * ringSize);
            } else {
                g2.setColor(Color.GRAY);
                g2.fillOval(xaux - (inssize /= 2) * ringSize / 2, yaux - inssize * (ringSize / 2), inssize * ringSize, inssize * ringSize);
            }
        }
    }

    public void drawHighlight(BufferedImage image, boolean highquality) {
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.drawHighlight(g2, highquality);
    }

    public void drawMark(Graphics2D g2, boolean highquality, double scale, boolean dashed, float opacity) {
        float ringSize = 0.0f;
        if (scale <= 0.3) {
            ringSize = 3.0f;
        } else if (scale > 0.3 && scale <= 0.7) {
            ringSize = 4.0f;
        } else if (scale > 0.7) {
            ringSize = 5.0f;
        }
        SimpleTreeModel treeModel = (SimpleTreeModel)this.model;
        if (highquality) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int xaux = (int)this.x;
        int yaux = (int)this.y;
        int inssize = treeModel.getInstanceSize();
        g2.setComposite(AlphaComposite.getInstance(3, treeModel.getAlpha()));
        g2.setColor(this.color);
        if (dashed) {
            float[] dash = new float[]{10.0f};
            g2.setStroke(new BasicStroke(3.0f, 0, 0, 10.0f, dash, 0.0f));
            g2.setComposite(AlphaComposite.getInstance(3, opacity));
            g2.setColor(Color.BLACK);
            g2.drawOval(xaux - (int)((float)inssize * ringSize / 2.0f), yaux - (int)((float)inssize * (ringSize / 2.0f)), (int)((float)inssize * ringSize), (int)((float)inssize * ringSize));
            g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f));
            g2.setColor(Color.WHITE);
        }
        g2.drawOval(xaux - (int)((float)inssize * ringSize / 2.0f), yaux - (int)((float)inssize * (ringSize / 2.0f)), (int)((float)inssize * ringSize), (int)((float)inssize * ringSize));
    }

    public int getParent() {
        return this.parent;
    }

    public void setParent(int parent) {
        this.parent = parent;
    }

    public boolean hasChildren() {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == -1) continue;
            return true;
        }
        return false;
    }

    public int getNumChildren() {
        int numChildren = 0;
        for (int childId : this.children) {
            if (childId == -1) continue;
            ++numChildren;
        }
        return numChildren;
    }

    public void setChildrenId(int i, int id) {
        if (i >= 0 && i < this.children.length) {
            this.children[i] = id;
        } else if (i > 0) {
            this.children = Arrays.copyOf(this.children, i + 1);
            this.children[i] = id;
        }
    }

    public void setChildrenDist(int i, float dist) {
        if (i >= 0 && i < this.childrenDist.length) {
            this.childrenDist[i] = dist;
        } else if (i > 0) {
            this.childrenDist = Arrays.copyOf(this.childrenDist, i + 1);
            this.childrenDist[i] = dist;
        }
    }

    public float getChidrenDist(int i) {
        if (i >= 0 && i < this.childrenDist.length) {
            return this.childrenDist[i];
        }
        return -1.0f;
    }

    public int getChildrenId(int i) {
        if (i >= 0 && i < this.children.length) {
            return this.children[i];
        }
        return -1;
    }

    public void removeScalar(int index) {
        if (this.scalars.size() > index) {
            this.scalars.remove(index);
        }
    }

    public int getRecursiveChildCount() {
        return this.recursiveChildCount;
    }

    public void setRecursiveChildCount(int recursiveChildrenCount) {
        this.recursiveChildCount = recursiveChildrenCount;
    }

    public boolean isShowImage() {
        return this.showImage;
    }

    public SimpleTreeInstance(int id, float x, float y, boolean valid) {
        super(id, x, y);
        this.setValid(valid);
        this.children = new int[3];
        this.childrenDist = new float[3];
        for (int i = 0; i < this.children.length; ++i) {
            this.children[i] = -1;
            this.childrenDist[i] = -1.0f;
        }
    }

    public int[] copyChildren() {
        int[] nchildren = new int[this.children.length];
        System.arraycopy(this.children, 0, nchildren, 0, this.children.length);
        float[] nchildrenDist = new float[this.childrenDist.length];
        System.arraycopy(this.childrenDist, 0, nchildrenDist, 0, this.childrenDist.length);
        return nchildren;
    }

    public void setChildren(int[] nchildren) {
        this.children = nchildren;
    }

    public int[] getChildren() {
        return this.children;
    }
}

