/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.bin;

import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.model.AbstractInstance;
import simpletree.model.Connectivity;
import simpletree.model.Scalar;
import simpletree.model.SimpleTreeConnectivity;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;

public class BINSimpleTreeModelWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SimpleTreeModel model, String filename) throws IOException {
        FileOutputStream fos = null;
        try {
            int numScalars;
            fos = new FileOutputStream(filename);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            int root = model.getRoot();
            oos.writeObject(root);
            String type = model.getType();
            oos.writeObject(type);
            int imagesSize = model.getImagesSize();
            oos.writeObject(imagesSize);
            float alpha = model.getAlpha();
            oos.writeObject(Float.valueOf(alpha));
            ArrayList<Connectivity> connectivities = model.getConnectivities();
            oos.writeObject(connectivities);
            if (connectivities != null && !connectivities.isEmpty()) {
                SimpleTreeConnectivity selsconn = model.getSelectedConnectivity();
                if (selsconn != null) {
                    oos.writeObject(connectivities.indexOf(selsconn));
                } else {
                    oos.writeObject(-1);
                }
            }
            int instanceSize = model.getInstanceSize();
            oos.writeObject(instanceSize);
            ArrayList<Scalar> scalars = model.getScalars();
            if (scalars != null && !scalars.isEmpty()) {
                numScalars = scalars.size();
                oos.writeObject(numScalars);
                for (int i = 0; i < scalars.size(); ++i) {
                    String scalarInfo = scalars.get(i).getName() + "#" + scalars.get(i).getMin() + "#" + scalars.get(i).getMax();
                    oos.writeObject(scalarInfo);
                }
                Scalar selscalar = model.getSelectedScalar();
                if (selscalar != null) {
                    oos.writeObject(scalars.indexOf(selscalar));
                } else {
                    oos.writeObject(-1);
                }
            } else {
                numScalars = 0;
                oos.writeObject(numScalars);
            }
            ArrayList<AbstractInstance> instances = model.getInstances();
            if (instances != null && !instances.isEmpty()) {
                int numInstances = instances.size();
                oos.writeObject(numInstances);
                for (int i = 0; i < instances.size(); ++i) {
                    int parent = ((SimpleTreeInstance)instances.get(i)).getParent();
                    oos.writeObject(parent);
                    Integer[] children = new Integer[((SimpleTreeInstance)instances.get(i)).getNumChildren()];
                    for (int j = 0; j < ((SimpleTreeInstance)instances.get(i)).getNumChildren(); ++j) {
                        children[j] = ((SimpleTreeInstance)instances.get(i)).getChildrenId(j);
                    }
                    oos.writeObject(children);
                    boolean valid = ((SimpleTreeInstance)instances.get(i)).isValid();
                    oos.writeObject(valid);
                    float x = ((SimpleTreeInstance)instances.get(i)).getX();
                    oos.writeObject(Float.valueOf(x));
                    float y = ((SimpleTreeInstance)instances.get(i)).getY();
                    oos.writeObject(Float.valueOf(y));
                    Color color = ((SimpleTreeInstance)instances.get(i)).getColor();
                    oos.writeObject(color);
                    int id = ((SimpleTreeInstance)instances.get(i)).getId();
                    oos.writeObject(id);
                    if (scalars == null || scalars.isEmpty()) continue;
                    for (int j = 0; j < scalars.size(); ++j) {
                        oos.writeObject(Float.valueOf(((SimpleTreeInstance)instances.get(i)).getScalarValue(scalars.get(j))));
                    }
                }
            } else {
                int numInstances = 0;
                oos.writeObject(numInstances);
            }
        }
        catch (FileNotFoundException e) {
            Logger.getLogger(BINSimpleTreeModelWriter.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (IOException e) {
            Logger.getLogger(BINSimpleTreeModelWriter.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                Logger.getLogger(BINSimpleTreeModelWriter.class.getName()).log(Level.SEVERE, null, e);
            }
        }
    }
}

