/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.content;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import simpletree.model.AbstractModel;
import simpletree.model.content.AbstractContent;
import simpletree.model.content.LabelContent;

public class ImageContent
extends AbstractContent {
    private Map<Integer, Image> imageMap = new HashMap<Integer, Image>();
    private final LabelContent labelMap;
    public final String path;
    private boolean keepOnMemory = false;

    public ImageContent(LabelContent labels, String path) {
        this.labelMap = labels;
        this.path = path;
        this.type = AbstractContent.Type.IMAGE;
    }

    @Override
    public boolean isEmpty() {
        return this.imageMap.isEmpty();
    }

    public Image load(String label) {
        if (this.path.endsWith(".zip")) {
            return this.loadFromZip(label);
        }
        return this.loadFromDir(label);
    }

    private Image loadFromDir(String label) {
        try {
            File file = new File(this.path + File.separator + label);
            return ImageIO.read(file);
        }
        catch (IOException ex) {
            System.err.println("Error loading image " + this.path + File.separator + label);
            return null;
        }
        catch (Exception ex) {
            System.err.println("Error loading image " + this.path + File.separator + label);
            return null;
        }
    }

    private Image loadFromZip(String label) {
        try {
            ZipFile zip = new ZipFile(this.path);
            ZipEntry entry = zip.getEntry(label.trim());
            if (entry != null) {
                InputStream is = zip.getInputStream(entry);
                return ImageIO.read(is);
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ImageContent.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public void setKeepOnMemory(boolean keepOnMemory) {
        this.keepOnMemory = keepOnMemory;
    }

    public boolean isKeepOnMemory() {
        return this.keepOnMemory;
    }

    @Override
    public Image get(int id) {
        if (this.keepOnMemory) {
            if (this.labelMap.get(id) == null) {
                return null;
            }
            if (this.imageMap.containsKey(id)) {
                return this.imageMap.get(id);
            }
            Image img = this.load(this.labelMap.get(id));
            this.imageMap.put(id, img);
            return img;
        }
        Image img = this.load(this.labelMap.get(id));
        return img;
    }

    @Override
    public boolean check(AbstractModel model) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getMemoryUsage() {
        long size = 0L;
        for (Image im : this.imageMap.values()) {
            DataBuffer dataBuffer = ((BufferedImage)im).getRaster().getDataBuffer();
            size += (long)(dataBuffer.getSize() * DataBuffer.getDataTypeSize(dataBuffer.getDataType()) / 8);
        }
        return size;
    }

    public static void main(String[] args) throws IOException {
        int i;
        LabelContent lc = new LabelContent();
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        Random rand = new Random();
        for (i = 0; i < 100000; ++i) {
            labelMap.put(rand.nextInt(400000) + 5000, "aaa.jpg");
        }
        labelMap.put(1, "0.jpg");
        for (i = 0; i < 100000; ++i) {
            labelMap.put(rand.nextInt(400000) + 5000, "aaa.jpg");
        }
        labelMap.put(100000, "1.jpg");
        lc.setMap(labelMap);
        ImageContent ic = new ImageContent(lc, "D:\\imagensCorel.zip");
        long init = System.currentTimeMillis();
        Image im = ic.get(100000);
        long end = System.currentTimeMillis();
        System.out.println("Time spent: " + (float)(end - init) / 1000.0f);
        init = System.currentTimeMillis();
        im = ic.get(100000);
        end = System.currentTimeMillis();
        System.out.println("Time spent: " + (float)(end - init) / 1000.0f);
        ic.get(1);
        System.out.println("Memory usage: " + (float)ic.getMemoryUsage() / 1024.0f + " KBytes");
        ImageIO.write((RenderedImage)((Object)im), "png", new File("D:\\teste.png"));
    }
}

