/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.newick;

import java.io.IOException;
import java.util.Stack;
import simpletree.basics.ContentSimpleTree;
import simpletree.basics.SimpleTree;
import simpletree.layout.radial.SupertreeRadialLayoutComp;
import simpletree.model.SimpleTreeInstance;
import simpletree.model.SimpleTreeModel;
import simpletree.model.SimpleTreeModelComp;
import simpletree.model.newick.NewickNode;
import simpletree.view.SimpleTreeFrameComp;

public class NewickUtils {
    public static NewickNode parse(String newickString) {
        Stack<NewickNode> nodeStack = new Stack<NewickNode>();
        StringBuilder branchContent = new StringBuilder();
        NewickNode parent = null;
        NewickNode root = null;
        NewickNode node = null;
        int level = -1;
        block6: for (int i = 0; i < newickString.length(); ++i) {
            switch (newickString.charAt(i)) {
                case '(': {
                    if (parent == null) {
                        root = parent = new NewickNode();
                        node = null;
                        continue block6;
                    }
                    nodeStack.push(parent);
                    parent = new NewickNode();
                    node = null;
                    continue block6;
                }
                case ',': {
                    if (node == null) {
                        node = new NewickNode();
                    } else {
                        for (NewickNode child : node.children) {
                            if (child.level < node.level) continue;
                            node.level = child.level + 1;
                        }
                    }
                    String[] branchValues = branchContent.toString().split(":");
                    node.id = branchValues[0];
                    node.parent = parent;
                    parent.children.add(node);
                    parent.distChildren.add(Float.valueOf(branchValues[1]));
                    branchContent = new StringBuilder();
                    node = null;
                    continue block6;
                }
                case ')': {
                    String[] branchValues;
                    if (node == null) {
                        node = new NewickNode();
                    } else {
                        for (NewickNode child : node.children) {
                            if (child.level < node.level) continue;
                            node.level = child.level + 1;
                        }
                    }
                    if (branchContent.length() > 0) {
                        branchValues = branchContent.toString().split(":");
                        if (branchValues.length > 1) {
                            node.id = branchValues[0];
                            node.parent = parent;
                            parent.children.add(node);
                            parent.distChildren.add(Float.valueOf(branchValues[1]));
                        } else {
                            parent.id = branchValues[0];
                            return parent;
                        }
                    }
                    branchContent = new StringBuilder();
                    node = parent;
                    if (nodeStack.empty()) continue block6;
                    parent = (NewickNode)nodeStack.pop();
                    continue block6;
                }
                case ';': {
                    String[] branchValues = branchContent.toString().split(":");
                    node.id = branchValues[0];
                    if (node.children.size() <= 0) continue block6;
                    for (NewickNode child : node.children) {
                        if (child.level < node.level) continue;
                        node.level = child.level + 1;
                    }
                    continue block6;
                }
                default: {
                    branchContent.append(newickString.charAt(i));
                }
            }
        }
        return root;
    }

    public static String toNewickString(NewickNode root) {
        StringBuilder result = new StringBuilder();
        NewickUtils.buildStringHelper(root, result);
        result.append(root.id);
        result.append(":0.0;");
        return result.toString();
    }

    public static String toNewickString(SimpleTree sTree) {
        Stack<ContentSimpleTree> stStack = new Stack<ContentSimpleTree>();
        Stack<NewickNode> nwStack = new Stack<NewickNode>();
        int rootId = sTree.getRootId();
        ContentSimpleTree stRoot = sTree.getNodeById(rootId);
        stStack.push(stRoot);
        NewickNode nwRoot = new NewickNode();
        nwRoot.id = Integer.toString(rootId);
        nwRoot.level = stRoot.getLevel();
        nwStack.push(nwRoot);
        while (!stStack.isEmpty()) {
            ContentSimpleTree stNode = (ContentSimpleTree)stStack.pop();
            NewickNode nwNode = (NewickNode)nwStack.pop();
            for (int i = 0; i < stNode.getNumChildren(); ++i) {
                int childId = stNode.getChildrenId(i);
                ContentSimpleTree stChild = sTree.getNodeById(childId);
                NewickNode nwChild = new NewickNode();
                nwChild.id = Integer.toString(childId);
                nwChild.level = stChild.getLevel();
                nwChild.parent = nwNode;
                nwNode.children.add(nwChild);
                nwNode.distChildren.add(Float.valueOf(stNode.getDistChildren(i)));
                if (!stChild.hasChildren()) continue;
                stStack.push(stChild);
                nwStack.push(nwChild);
            }
        }
        return NewickUtils.toNewickString(nwRoot);
    }

    public static String toNewickString(SimpleTreeModel stModel) {
        Stack<SimpleTreeInstance> stStack = new Stack<SimpleTreeInstance>();
        Stack<NewickNode> nwStack = new Stack<NewickNode>();
        int rootId = stModel.getRoot();
        SimpleTreeInstance stRoot = stModel.getInstanceById(rootId);
        stStack.push(stRoot);
        NewickNode nwRoot = new NewickNode();
        nwRoot.id = Integer.toString(rootId);
        nwRoot.level = stRoot.level;
        nwStack.push(nwRoot);
        while (!stStack.isEmpty()) {
            SimpleTreeInstance stNode = (SimpleTreeInstance)stStack.pop();
            NewickNode nwNode = (NewickNode)nwStack.pop();
            for (int i = 0; i < stNode.getNumChildren(); ++i) {
                int childId = stNode.getChildrenId(i);
                SimpleTreeInstance stChild = stModel.getInstanceById(childId);
                NewickNode nwChild = new NewickNode();
                nwChild.id = Integer.toString(childId);
                nwChild.level = stChild.level;
                nwChild.parent = nwNode;
                nwNode.children.add(nwChild);
                nwNode.distChildren.add(Float.valueOf(stNode.childrenDist[i]));
                if (!stChild.hasChildren()) continue;
                stStack.push(stChild);
                nwStack.push(nwChild);
            }
        }
        return NewickUtils.toNewickString(nwRoot);
    }

    private static void buildStringHelper(NewickNode root, StringBuilder buffer) {
        buffer.append("(");
        for (int i = 0; i < root.children.size(); ++i) {
            NewickNode child = root.children.get(i);
            if (child.children.size() > 0) {
                NewickUtils.buildStringHelper(child, buffer);
            }
            buffer.append(child.id);
            buffer.append(":");
            buffer.append(root.distChildren.get(i));
            if (i >= root.children.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append(")");
    }

    public static void main(String[] args) throws IOException {
        String newickTree = "((((101585:0.010770330433009,101547:0.014086437994543)202299:0.008928968136323,(101584:0.045718102702620,101542:0.032053299196977)202308:0.005549499000998)202334:0.001856891188085,((101550:0.015387950020021,((101571:0.019391164629267,101579:0.012846503198416)202305:0.006377506220170,(101551:0.016288619522214,(101577:0.012087017224298,101582:0.014435291306313)202315:0.002261286671899)202324:0.001894526563342)202329:0.001559568816713)202331:0.001254816029380,(((101561:0.011374842347994,((101583:0.040490441861817,101553:0.015924779793928)202316:0.002534864642511,101544:0.016123882099427)202320:0.001126242368448)202323:0.002421918172666,(101543:0.017265737496749,((101565:0.010004136736300,101562:0.008774888262389)202321:0.002042388998682,(101574:0.021333823321345,(101545:0.014006114899222,101540:0.010403142735536)202319:0.002415563165680)202325:0.000611931405225)202326:0.000439509337409)202327:0.000915198260315)202328:0.002198938525741,((101572:0.010946282228846,101549:0.017478118602871)202317:0.002964516031730,((101568:0.012536432550537,101578:0.026361608549730)202307:0.004300030706528,(101552:0.013491290098891,(101560:0.015438986583709,((101559:0.015077172315086,101546:0.020892984850081)202300:0.000471109140253,101539:0.020842034632902)202301:0.003944812743721)202306:0.001261020014011)202310:0.003391190273116)202318:0.001492707906948)202322:0.003867767186332)202332:0.001007123387622)202333:0.002235984979192)202339:0.000205870588871,((101563:0.018912305984139,101557:0.013834422207620)202304:0.006565277307647,((101575:0.035093899122907,(101570:0.028074886443214,101554:0.024220704054744)202311:0.000305044070477)202312:0.002525340020489,(101573:0.013721339360566,(101555:0.014751892114835,101548:0.020207631213560)202303:0.001100198786738)202309:0.003180939958690)202314:0.004897014417289)202335:0.000945011170019,((((101556:0.045567449729979,101566:0.034176957858683)202330:0.001779927516291,(101564:0.018056404058555,101558:0.025844315014104)202298:0.009440306870501)202336:0.000614388674905,101567:0.015237154349964)202337:0.001141738995100,((((101581:0.029326332410143,101576:0.028511515938446)202296:0.002844573658202,101569:0.025277425921618)202297:0.006848694526309,101580:0.011383221181208)202302:0.002766916462713,101541:0.025079374945382)202313:0.005474885395585)202338:0.000823682241713)202340:0.0;";
        NewickNode root = NewickUtils.parse(newickTree);
        String rebuiltString = NewickUtils.toNewickString(root);
        SimpleTree sTree = new SimpleTree(newickTree);
        rebuiltString = NewickUtils.toNewickString(sTree);
        SimpleTreeModelComp modelComp = new SimpleTreeModelComp();
        modelComp.input(sTree);
        modelComp.execute();
        SupertreeRadialLayoutComp radialComp = new SupertreeRadialLayoutComp();
        radialComp.input(modelComp.output());
        radialComp.execute();
        SimpleTreeFrameComp frameComp = new SimpleTreeFrameComp();
        frameComp.input(radialComp.output());
        frameComp.execute();
        System.out.println("END!");
    }
}

