/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.io.IOException;
import simpletree.model.GraphModel;
import simpletree.model.xml.XMLGraphModelReader;
import simpletree.model.xml.XMLGraphModelReaderParamView;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Input", name="Graph model XML reader", description="Read a projection model from an XML file.")
public class XMLGraphModelReaderComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename = "";
    private transient GraphModel model;
    private transient XMLGraphModelReaderParamView paramview;

    public void execute() throws IOException {
        if (this.filename.trim().length() <= 0) {
            throw new IOException("A projection model file name must be provided to write.");
        }
        XMLGraphModelReader xmr = new XMLGraphModelReader();
        this.model = new GraphModel();
        xmr.read(this.model, this.filename);
    }

    public GraphModel output() {
        return this.model;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new XMLGraphModelReaderParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.model = null;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

