/*
 * Decompiled with CFR 0.152.
 */
package simpletree.model.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import simpletree.model.xml.XMLSimpleTreeModelReaderComp;
import simpletree.util.OpenDialog;
import simpletree.util.PropertiesManager;
import simpletree.util.filter.XMLFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class XMLSimpleTreeModelReaderParamView
extends AbstractParametersView {
    private XMLSimpleTreeModelReaderComp comp;
    private JLabel matrixLabel;
    private JButton treeButton;
    private JTextField treeTextField;

    public XMLSimpleTreeModelReaderParamView(XMLSimpleTreeModelReaderComp comp) {
        this.initComponents();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.matrixLabel = new JLabel();
        this.treeTextField = new JTextField();
        this.treeButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder("XML Tree Model Reader"));
        this.setLayout(new GridBagLayout());
        this.matrixLabel.setText("File name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.matrixLabel, gridBagConstraints);
        this.treeTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.treeTextField, gridBagConstraints);
        this.treeButton.setText("Search...");
        this.treeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLSimpleTreeModelReaderParamView.this.treeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.treeButton, gridBagConstraints);
    }

    private void treeButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("projection.properties");
            int result = OpenDialog.showOpenDialog(spm, new XMLFilter(), (Component)((Object)this));
            if (result == 0) {
                String filename = OpenDialog.getFilename();
                this.treeTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(XMLSimpleTreeModelReaderParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.treeTextField.setText(this.comp.getFilename());
    }

    public void finished() throws IOException {
        if (this.treeTextField.getText().trim().length() <= 0) {
            throw new IOException("A tree file name must be provided.");
        }
        this.comp.setFilename(this.treeTextField.getText());
    }
}

