/*
 * Decompiled with CFR 0.152.
 */
package simpletree.projection.stress;

import java.io.IOException;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.projection.stress.Stress;
import simpletree.projection.stress.StressFactory;
import simpletree.projection.stress.StressParamView;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Projection.Basics", name="Calculate Stress", description="Calculate how the distances relations of a projection differ from the original distances relations.")
public class StressComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private StressFactory.StressType stresstype = StressFactory.StressType.KRUSKAL;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private transient StressParamView paramview;
    private transient float stress;
    private transient AbstractMatrix projection;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;

    public void execute() throws IOException {
        Stress stresscalc = StressFactory.getInstance(this.stresstype);
        if (this.matrix != null) {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            this.stress = stresscalc.calculate(this.projection, this.matrix, diss);
        } else if (this.dmat != null) {
            this.stress = stresscalc.calculate(this.projection, this.dmat);
        } else {
            throw new IOException("A distance matrix or a points matrix should be provided.");
        }
    }

    public void input(@Param(name="projection") AbstractMatrix projection, @Param(name="points matrix") AbstractMatrix matrix) {
        this.projection = projection;
        this.matrix = matrix;
    }

    public void input(@Param(name="projection") AbstractMatrix projection, @Param(name="distance matrix") DistanceMatrix dmat) {
        this.projection = projection;
        this.dmat = dmat;
    }

    public Float output() {
        return Float.valueOf(this.stress);
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new StressParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.projection = null;
        this.matrix = null;
        this.dmat = null;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public boolean isDistanceMatrixProvided() {
        return this.dmat != null;
    }

    public StressFactory.StressType getStressType() {
        return this.stresstype;
    }

    public void setStressType(StressFactory.StressType stresstype) {
        this.stresstype = stresstype;
    }
}

